% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summarize_nse.R
\name{summarize_nse}
\alias{summarize_nse}
\alias{summarise_nse}
\title{summarize non-standard evaluation interface.}
\usage{
summarize_nse(.data, ..., env = parent.frame())

summarise_nse(.data, ..., env = parent.frame())
}
\arguments{
\item{.data}{data.frame}

\item{...}{stringified expressions to summarize by.}

\item{env}{environment to work in.}
}
\value{
.data with summarized columns.
}
\description{
summarize a data frame by the summarizeTerms.  Accepts arbitrary text as
summarizeTerms to allow forms such as "Sepal.Length >= 2 * Sepal.Width".
Terms are vectors or lists of the form "lhs := rhs".
}
\examples{


resCol <- "Sepal_Mean_Length"
varCol <- "Sepal.Length"

datasets::iris \%.>\%
  group_by_se(., 'Species') \%.>\%
  summarize_nse(., resCol := mean(varCol),
                   "max_Sepal_Length" := max("Sepal.Length"))


}
\seealso{
\code{\link{summarize_se}}, \code{\link[dplyr]{summarize}}, \code{\link[dplyr]{summarize_at}}, \code{\link[wrapr]{:=}}
}
