% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/complete_se.R
\name{complete_se}
\alias{complete_se}
\title{complete by standard interface}
\usage{
complete_se(data, col_terms, fill = list(), env = parent.frame())
}
\arguments{
\item{data}{A data frame or tbl.}

\item{col_terms}{A character vector of column names or expressions to complete by.}

\item{fill}{A list that for each variable supplies a single value to use instead of NA for missing combinations.}

\item{env}{The environment as an argument (in case the function is called from another function).}
}
\value{
The data frame with implicit missing values identified.
}
\description{
Complete a data frame with missing combinations of data. Turns implicit missing values into explicit missing values.
}
\details{
This is a standard evaluation interface for \code{tidyr::complete()}. The purpose of the function is to be able to use a vector of characters (column names) as the argument for expanding the data frame.
}
\examples{

# data frame used to illustrate tidyr::complete()
df <- wrapr::build_frame(
  "group"  , "item_id", "item_name", "value1", "value2" |
    1      , 1        , "a"        , 1L      , 4L       |
    2      , 2        , "b"        , 2L      , 5L       |
    1      , 2        , "b"        , 3L      , 6L       )

# columns to complete by
col_terms <- qc(group, item_id, item_name)
df \%.>\% complete_se(., col_terms)
df \%.>\% complete_se(., col_terms, fill = list(value1 = 0))

# with nesting
col_terms <- c("group", "tidyr::nesting(item_id, item_name)")
df \%.>\% complete_se(., col_terms)
df \%.>\% complete_se(., col_terms, fill = list(value1 = 0))
df \%.>\% complete_se(., col_terms, fill = list(value1 = 0, value2 = 0))

}
