% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GenoConvert.R
\name{GenoConvert}
\alias{GenoConvert}
\title{Convert genotype file}
\usage{
GenoConvert(InFile = NULL, InFormat = "raw", OutFile = NULL,
  OutFormat = "seq", quiet = FALSE)
}
\arguments{
\item{InFile}{character string with name of genotype file to be converted}

\item{InFormat}{One of "raw", "ped", "col" or "seq", see Details.}

\item{OutFile}{character string with name of converted file. If NA, return
matrix with genotypes in console; if NULL, write to "GenoForSequoia.txt".}

\item{OutFormat}{as InFormat, default is "seq".}

\item{quiet}{suppress messages}
}
\value{
The converted genotype data is written to the specified file.
}
\description{
Convert a genotype file from PLINK's .ped or .RAW, or Colony's 2-column-
 per-marker format, to sequoia's 1-column-per-marker format.
}
\details{
The following formats are currently supported, specified by 'InFormat' and
  'OutFormat':
 \itemize{
   \item{ped: }{No header row, 6 descriptive columns, genotypes are coded as
   A, C, T, G, missing as 0, in 2 columns per marker. NOTE: not yet
   implented, use PLINK's --recodeA to convert this format to "raw".}
   \item{raw: }{Header row with SNP names, 6 descriptive columns,
    genotypes are coded as 0, 1, 2, missing as NA, in 1 column per marker.}
   \item{col: }{No header row, 1 descriptive column, genotypes are coded as
   numeric values, missing as 0, in 2 columns per marker.}
   \item{seq: }{No header row, 1 descriptive column genotypes are coded as
   0, 1, 2, missing as -9, in 1 column per marker.}
 }
}
\examples{
\dontrun{
# Requires PLINK installed & in PATH:
system("cmd", input = "plink --file mydata --extract plink.prune.in
  --recodeA --out PlinkOUT")
#
GenoM <- GenoConvert(InFile = "PlinkOUT.raw", OutFile = NA)
}

}
\author{
Jisca Huisman, \email{jisca.huisman@gmail.com}
}
\seealso{
\code{\link{sequoia}}
}

