% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PairRelation.R
\name{GetRelCat}
\alias{GetRelCat}
\title{Pairwise relationship}
\usage{
GetRelCat(x, Pedigree, GenBack = 2, patmat = TRUE)
}
\arguments{
\item{x}{The focal individual, either its rownumber in the pedigree or ID.}

\item{Pedigree}{dataframe columns id - dam - sire.}

\item{GenBack}{Number of generations back to consider; 1 returns
parent-offspring and sibling relationships, 2 also returns grandparental,
avuncular and first cousins.}

\item{patmat}{logical, distinguish between paternal versus maternal relative
pairs?}
}
\value{
A named vector of length equal to the number of rows in Ped, with for
  each ID its relationship to the focal individual:
   \item{S}{Self}
   \item{M}{Mother}
   \item{P}{Father}
   \item{O}{Offspring}
   \item{FS}{Full sibling}
   \item{MHS}{Maternal half-sibling}
   \item{PHS}{Paternal half-sibling}
   \item{MGM}{Maternal grandmother}
   \item{MGF}{Maternal grandfather}
   \item{PGM}{Paternal grandmother}
   \item{PGF}{Paternal grandfather}
   \item{GO}{Grand-offspring}
   \item{FA}{Full avuncular; maternal or paternal aunt or uncle}
   \item{HA}{Half avuncular}
   \item{FN}{Full nephew/niece}
   \item{HN}{Half nephew/niece}
   \item{FC1}{Full first cousin}
   \item{DFC1}{Double full first cousin}
   \item{U}{Unrelated (or otherwise related)}
}
\description{
Determine the relationship between individual X and all other
  individuals in the pedigree, going up to 1 or 2 generations back.
}
\examples{
data(Ped_griffin)
# find all relatives of a specific individual
Rel42 <- GetRelCat("i042_2003_F", Ped_griffin)
Rel42[Rel42 != "U"]

# make NxN matrix with relationship categories:
Ped_griffin_sub <- Ped_griffin[Ped_griffin$birthyear<2003,]  # quicker
RCM <- sapply(seq_along(Ped_griffin_sub$id), GetRelCat, Ped_griffin_sub)
table(RCM)
#   M  MHS    O    P    S    U
#  10    6   16    6   40 1522
# note that sibling & cousin pairs are counted twice!
# Parent-offspring pairs are counted directionally:
# once as offspring (O), once as mother (M) or father (P)

# for large pedigrees, table(factor()) is much faster:
table(factor(RCM, levels=c("M","P","FS","MHS","PHS","U")))

# list the maternal half-siblings:
these <- which(RCM=="MHS", arr.ind=TRUE)
data.frame(id1 = Ped_griffin_sub$id[these[,1]],
           id2 = Ped_griffin_sub$id[these[,2]])


# Get Colony-style lists of full sibs & half sibs dyads:
\dontrun{
RCM <- sapply(seq_along(MyPedigree$id), GetRelCat, Pedigree = MyPedigree,
              GenBack = 1, patmat = FALSE)
# rownumbers of pairs of FS & HS
FullSibDyads <- which(RCM == "FS", arr.ind=TRUE)
HalfSibDyads <- which(RCM == "HS", arr.ind=TRUE)

# each pair is listed 2x - fix:
FullSibDyads <- FullSibDyads[FullSibDyads[,1] < FullSibDyads[,2], ]
HalfSibDyads <- HalfSibDyads[HalfSibDyads[,1] < HalfSibDyads[,2], ]

# translate rownumbers into IDs
MyPedigree$id <- as.character(MyPedigree$id)
FullSibDyads <- cbind(MyPedigree$id[FullSibDyads[,1]],
                      MyPedigree$id[FullSibDyads[,2]])
HalfSibDyads <- cbind(MyPedigree$id[HalfSibDyads[,1]],
                      MyPedigree$id[HalfSibDyads[,2]])
}

}
\seealso{
\code{\link{ComparePairs}} to compare pairwise relationships
  between 2 pedigrees.
}
