% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GetMaybeRel.R
\name{GetMaybeRel}
\alias{GetMaybeRel}
\title{Find Putative Relatives}
\usage{
GetMaybeRel(
  GenoM = NULL,
  SeqList = NULL,
  Pedigree = NULL,
  LifeHistData = NULL,
  AgePrior = NULL,
  ParSib = NULL,
  Module = "par",
  Complex = "full",
  Herm = "no",
  Err = 1e-04,
  ErrFlavour = "version2.0",
  MaxMismatch = NA,
  Tassign = 0.5,
  Tfilter = -2,
  MaxPairs = 7 * nrow(GenoM),
  quiet = FALSE
)
}
\arguments{
\item{GenoM}{numeric matrix with genotype data: One row per individual, and
one column per SNP, coded as 0, 1, 2 or -9 (missing). See also
\code{\link{GenoConvert}}.}

\item{SeqList}{list with output from \code{\link{sequoia}}.
\code{SeqList$Pedigree} is used if present, and \code{SeqList$PedigreePar}
otherwise, and overrides the input parameter \code{Pedigree}. If 'Specs' is
present, its elements override all input parameters with the same name. The
list elements  `LifeHist', `AgePriors', and `ErrM' are also used if
present, and similarly override the corresponding input parameters.}

\item{Pedigree}{dataframe with id - dam - sire in columns 1-3. May include
non-genotyped individuals, which will be treated as dummy individuals. When
provided, all likelihoods (and thus all maybe-relatives) are conditional on
this pedigree. Note: \code{SeqList$Pedigree} or \code{SeqList$PedigreePar} take
precedent (for this function only).}

\item{LifeHistData}{dataframe with 3 columns (optionally 5):
 \describe{
 \item{ID}{max. 30 characters long}
 \item{Sex}{1 = female, 2 = male, 3 = unknown, 4 = hermaphrodite,
           other numbers or NA = unknown}
\item{BirthYear }{birth or hatching year, integer, with missing values as NA
  or any negative value.}
\item{BY.min}{minimum birth year, only used if BirthYear is missing}
\item{BY.max}{maximum birth year, only used if BirthYear is missing} }
If the species has multiple generations per year, use an integer coding such
that the candidate parents' `Birth year' is at least one smaller than their
putative offspring's. Column names are ignored, so ensure column order is ID
- sex - birth year (- BY.min - BY.max). Individuals do not need to be in the
same order as in `GenoM', nor do all genotyped individuals need to be
included.}

\item{AgePrior}{Agepriors matrix, as generated by \code{\link{MakeAgePrior}}
and included in the \code{\link{sequoia}} output. Affects which
relationships are considered possible (only those where \eqn{P(A|R) / P(A)
> 0}).}

\item{ParSib}{either 'par' to check for putative parent-offspring pairs only,
or 'sib' to check for all types of first and second degree relatives. This
argument will be deprecated, please use \code{Module}.}

\item{Module}{type of relatives to check for. One of
\describe{
  \item{par}{parent - offspring pairs}
  \item{ped}{all first and second degree relatives}
}
When 'par', all pairs are returned that are more likely parent-offspring
than unrelated, potentially including pairs that are even more likely to
be otherwise related.}

\item{Complex}{Breeding system complexity. Either "full" (default), "simp"
(simplified, no explicit consideration of inbred relationships), "mono"
(monogamous).}

\item{Herm}{Hermaphrodites, either "no", "A" (distinguish between dam and
sire role, default if at least 1 individual with sex=4), or "B" (no
distinction between dam and sire role). Both of the latter deal with
selfing.}

\item{Err}{estimated genotyping error rate, as a single number or 3x3 matrix.
Details below. The error rate is presumed constant across SNPs, and
missingness is presumed random with respect to actual genotype.}

\item{ErrFlavour}{function that takes \code{Err} (single number) as input,
and returns a 3x3 matrix of observed (columns) conditional on actual (rows)
genotypes, or choose from inbuilt options 'version2.0', 'version1.3', or
'version1.1', referring to the sequoia version in which they were the
default. Ignored if \code{Err} is a matrix. See \code{\link{ErrToM}}.}

\item{MaxMismatch}{\strong{DEPRECATED AND IGNORED}. Now calculated
automatically using \code{\link{CalcMaxMismatch}}.}

\item{Tassign}{minimum LLR required for acceptance of proposed relationship,
relative to next most likely relationship. Higher values result in more
conservative assignments. Must be zero or positive.}

\item{Tfilter}{threshold log10-likelihood ratio (LLR) between a proposed
relationship versus unrelated, to select candidate relatives. Typically a
negative value, related to the fact that unconditional likelihoods are
calculated during the filtering steps. More negative values may decrease
non-assignment, but will increase computational time.}

\item{MaxPairs}{the maximum number of putative pairs to return.}

\item{quiet}{logical, suppress messages.}
}
\value{
A list with
  \item{MaybePar or MaybeRel}{A dataframe with non-assigned likely
    relatives, with columns ID1 - ID2 - TopRel - LLR - OH - BirthYear1 -
    BirthYear2 - AgeDif - Sex1 - Sex2 - SNPdBoth}
  \item{MaybeTrio}{A dataframe with non-assigned parent-parent-offspring
    trios, with columns id - parent1 - parent2 - LLRparent1 - LLRparent2 -
    LLRpair - OHparent1 - OHparent2 - MEpair - SNPd.id.parent1 -
    SNPd.id.parent2}
The following categories are used in column 'TopRel', indicating the most
likely relationship category:
\item{PO}{Parent-Offspring}
\item{FS}{Full Siblings}
\item{HS}{Half Siblings}
\item{GP}{GrandParent - grand-offspring}
\item{FA}{Full Avuncular (aunt/uncle)}
\item{2nd}{2nd degree relatives, not enough information to distinguish
  between HS,GP and FA}
\item{Q}{Unclear, but probably 1st, 2nd or 3rd degree relatives}
}
\description{
Identify pairs of individuals likely to be related, but not
  assigned as such in the provided pedigree.
}
\details{
When \code{Module="par"}, the age difference of the putative pair is
  temporarily set to NA so that genetic parent-offspring pairs declared to be
  born in the same year may be discovered. When \code{Module="ped"}, only
  relationships possible given the age difference, if known from the
  LifeHistData, are considered.
}
\examples{
\donttest{
SeqOUT <- sequoia(GenoM = SimGeno_example,
                  LifeHistData = LH_HSg5,
                  Module = "par",
                  quiet=TRUE, Plot=FALSE)
MaybePO <- GetMaybeRel(GenoM = SimGeno_example,
                      SeqList = SeqOUT)
head(MaybePO$MaybePar)

# instead of providing the entire SeqList, one may
# specify the relevant elements separately
Maybe <- GetMaybeRel(GenoM = SimGeno_example,
                     Pedigree = SeqOUT$PedigreePar,
                     LifeHistData = LH_HSg5,
                     Err=0.0001, Complex = "full",
                     Module = "ped")
head(Maybe$MaybeRel)

# visualise results, turn dataframe into matrix first:
MaybeM <- GetRelM(Pairs=Maybe$MaybeRel)
PlotRelPairs(MaybeM)
}

}
\seealso{
\code{\link{sequoia}} to identify likely pairs of duplicate
  genotypes and for pedigree reconstruction; \code{\link{GetRelM}} to
  identify all pairs of relatives in a pedigree; \code{\link{CalcPairLL}} for
  the likelihoods underlying the LLR.
}
