% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Report.R
\name{sequoia_report}
\alias{sequoia_report}
\title{Sequoia report}
\usage{
sequoia_report(
  SeqList = NA,
  GenoM = NA,
  MaybeRel = NA,
  Conf = NA,
  comments = "",
  printcode = "yes",
  output_file = "",
  output_format = "html_document",
  copy_rmd = FALSE
)
}
\arguments{
\item{SeqList}{list with output from \code{\link{sequoia}}. If not provided,
all other input is ignored and an example report using the griffin data is
generated.}

\item{GenoM}{genotype matrix that was used to run \code{\link{sequoia}}.}

\item{MaybeRel}{list with output from \code{\link{GetMaybeRel}}.}

\item{Conf}{list with output from \code{\link{EstConf}}.}

\item{comments}{optional comments to print at the top of the report.}

\item{printcode}{include R code in the report ('yes', default) or not ('no').
The R code includes some brief notes and references to relevant functions.}

\item{output_file}{filename (incl. path) for the report. Extension (.html,
.pdf) not needed.}

\item{output_format}{format for the report, e.g. \code{'html_document'},
\code{rmarkdown::pdf_document(toc=TRUE, extra_dependencies = 'booktabs')},
or \code{bookdown::gitbook(split_by='none')}. See
\code{\link[rmarkdown]{render}} for details and options. Note that
\code{'bookdown::gitbook'}, and possibly others, appear to only work after
copying the .rmd file to the output folder.}

\item{copy_rmd}{copy the .rmd file to the output folder? (i.e. same folder as
\code{output_file}).}
}
\value{
A file with the report in the specified output format.
}
\description{
Create a summary report of the genotype data and reconstructed
  pedigree, utilising a range of functions in the \code{sequoia} package.
  For many of the plots and tables, brief help on interpretation is provided.
}
\details{
The R markdown (.Rmd) file for the report is included with the
  package, and may freely be modified and re-used.
}
\examples{
\dontrun{
sequoia_report(comments = 'This is a test',
               file = file.path(getwd(), 'test_griffins'))
}

}
