% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/set.R
\name{drill_set}
\alias{drill_set}
\title{Set Drill SYSTEM or SESSION options}
\usage{
drill_set(drill_con, ..., type = c("session", "system"))
}
\arguments{
\item{drill_con}{drill server connection object setup by \code{drill_connection()}}

\item{...}{named parameters to be sent to ALTER [SYSTEM|SESSION]}

\item{type}{set the \code{session} or \code{system} parameter}
}
\value{
a \code{tbl} (invisibly) with the \code{ALTER} queries sent and results, including errors.
}
\description{
Helper function to make it more R-like to set Drill SESSION or SYSTEM optons. It
handles the conversion of R types (like \code{TRUE}) to SQL types and automatically
quotes parameter values (when necessary).
}
\details{
If any query errors result, error messages will be presented to the console.
}
\examples{
\dontrun{
drill_connection() \%>\%
  drill_set(exec.errors.verbose=TRUE, store.format="parquet", web.logs.max_lines=20000)
}
}
\references{
\href{https://drill.apache.org/docs/}{Drill documentation}
}
