% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/serp.performance.R
\name{errorMetrics}
\alias{errorMetrics}
\title{Performance metrics for categorical response models}
\usage{
errorMetrics(
             actual,
             predicted,
             type= c("brier", "logloss", "misclass"),
             control = list())
}
\arguments{
\item{actual}{vector of actual values observed}

\item{predicted}{predicted probability matrix of a categorical model or a
vector of fitted values for binary models.}

\item{type}{specifies the type of error metrics.}

\item{control}{A list of control parameters to replace default values
returned by \code{serp.control}. 'misclass.thresh' resets the default
misclassification error threshold, while 'minP' assigns a near-zero constant
value to the predicted values beyond certain threshold, to forestall chances
of numerical problems.}
}
\value{
\item{value}{the value of error measure computed.}

\item{type}{the error measure used: any of brier, logLoss or misclassification error.}

\item{threshold}{the misclassification threshold.}
}
\description{
Calculates the performance metrics of fitted binary and
multi-categorical response models. Available measures include: brier score,
logloss and misclassification error.
}
\details{
A numeric value of the selected error type determining how
good a categorical model compares to competing models.
}
\examples{

require(serp)

m1 <- serp(rating ~ temp + contact, slope = "parallel", link = "logit", data = wine)
errorMetrics(m1, type = "brier")

## objects of class other than \code{serp} require the actual
## observations with corresponding predicted values supplied.

set.seed(2)
n <- 50
y <- as.factor(rbinom(n, 1, 0.5))
m2 <- glm(y ~ rnorm(n), family = binomial())
ft <- m2$fitted.values

errorMetrics(actual=y, predicted=ft, type = "logloss")
errorMetrics(actual=y, predicted=ft, type = "misclass")

## Reset classification threshold
errorMetrics(actual=y, predicted=ft, type = "misclass",
control = list(misclass.thresh=0.4))

}
\seealso{
\code{\link{serp}}, \code{\link{anova.serp}}, \code{\link{confint.serp}},
\code{\link{vcov.serp}}
}
