% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{sumDlogNorm}
\alias{sumDlogNorm}
\title{Sum log-likelihoods of i.i.d. lognormal.}
\usage{
sumDlogNorm(x, meanlog, sdlog)
}
\arguments{
\item{x}{Vector of i.i.d. lognormal random varibles}

\item{meanlog}{mean of the distribution on the log scale}

\item{sdlog}{standard deviation on the log scale}
}
\value{
log-likelihood of x
}
\description{
This is an internal function that is only exposed on the public API for unit testing purposes.
}
\details{
The sum of the log-likelihoods (log of the product of the likelihoods)
for independent, identically-distributed, lognormal random variables. 
Note: this Rcpp function is thread-safe, unlike the equivalent alternatives.
}
\seealso{
\code{sum(dlnorm(x, meanlog, sdlog, log=TRUE))}
}
