% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{marginalMetropolisUpdate}
\alias{marginalMetropolisUpdate}
\title{Update all of the parameters using a single Metropolis-Hastings step.}
\usage{
marginalMetropolisUpdate(spectra, n, conc, wavelengths, peakWL, betaMx, scaleMx,
  sigma, expMx, baselines, sd_mh, priors)
}
\arguments{
\item{spectra}{\code{n_y * nwl} Matrix of observed Raman spectra.}

\item{n}{number of observations to use in calculating the likelihood}

\item{conc}{Vector of \code{n} nanomolar (nM) dye concentrations}

\item{wavelengths}{Vector of \code{nwl} wavenumbers at which the spetra are observed.}

\item{peakWL}{Vector of locations for each peak (cm^-1)}

\item{betaMx}{\code{npeaks * npart} Matrix of regression coefficients to update.}

\item{scaleMx}{\code{npeaks * npart} Matrix of scale parameters to update.}

\item{sigma}{Vector of \code{npart} standard deviations to update.}

\item{expMx}{\code{nwl * npart} Matrix of expectations of the Lorentzian or Gaussian function.}

\item{baselines}{\code{nKnots * n_y * npart} Array of smoothing splines.}

\item{sd_mh}{Vector of \code{2 * npeaks} bandwidths for the random walk proposals.}

\item{priors}{List of hyperparameters for the prior distributions.}
}
\value{
The number of RWMH proposals that were accepted.
}
\description{
Updates all of the parameters using a single Metropolis-Hastings step, such that the
baseline cancels out in the MH ratio, using the marginalisation identity of Chib (1995).
If \code{npart > 1}, then multiple MCMC chains will be executed independently in parallel using OpenMP.
This means that all functions used for the proposal distributions and to evaluate the MH ratio
need to be thread-safe. Specifically, no calls to \code{R::rnorm}, \code{R::dnorm}, nor their
Rcpp equivalents, can be made from within the parallel portion of the code.
}
\references{
Chib (1995) "Marginal Likelihood from the Gibbs Output," JASA 90(432): 1313--1321,
DOI: \href{http://dx.doi.org/10.1080/01621459.1995.10476635}{10.1080/01621459.1995.10476635}

Rosenthal (2000) "Parallel computing and Monte Carlo algorithms" Far East J. Theor. Stat. 4(2): 207--236,
URL: \href{http://www.pphmj.com/abstract/1961.htm}{http://www.pphmj.com/abstract/1961.htm}
}
