% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fetch_clean_functions.R
\name{mergeTrialInfo}
\alias{mergeTrialInfo}
\title{Merge trial id information}
\usage{
mergeTrialInfo(list, trial.data, col.names, stimulus.keep,
  stimulus.split = FALSE)
}
\arguments{
\item{list}{The list of servosphere output data.}

\item{trial.data}{The data frame containing your trial id information. This
must contain an identifier column titled `id` and if the data are to be
split by stimuli, an additional identifier column `id_stim`. See the
description for more details.}

\item{col.names}{A string vector containing the names of the columns you want
to transfer to your servosphere output data. The trial.data data frame may
have columns not needed for the analysis, so the function asks the user to
be explicit about which columns to retain.}

\item{stimulus.keep}{An integer vector containing the stimuli numbers to
retained in the data and split the data frames by. Omitted stimuli values
will be discarded.}

\item{stimulus.split}{A logical value indicating whether the data frames
should be split by stimulus. Defaults to `FALSE`. If `TRUE`, be sure to
include a `id_stim` column to give each trial/stimulus combination a unique
ID.}
}
\value{
Returns the list of data frames provided which have been merged with
  additional relevant trial information.
}
\description{
This function merges trial id information with the servosphere data.
}
\details{
Users of the servosphere will need a separate data frame with trial id
information in a column titled \code{id}. This should contain a unique
identifier and any other relevant experimental information, such as
treatments applied, date, time of day, etc. Make sure the rows in your trial
id data frame are ordered in the same order as the list of data frames of
your servosphere output.

Researchers may wish to compare data before and after some stimulus has been
applied and this function allows the user to split their data into separate
data frames based on different values of the stimulus variable to facilitate
these comparison. If the data frames should be split by stimulus, the trial
record data frame should contain a column \code{id_stim} that lists the id
number of the trial, followed by an underscore, followed by each value of the
stimulus variable retained. If the data should be split by stimulus, the rows
of the trial id data frame should be ordered first by \code{id} in the same
order as their data is stored within the list. Once ordered by \code{id} the
trial data data frame should be further ordered within an \code{id} by
\code{stimulus} (i.e. id_stim 1_1 should come before id_stim 1_2).

Data recorded during a particular stimuli may also be discarded if it is not
required for analysis. For example, recordings may begin with a five minute
adjustment period and the data associated with that period may not be used
for analysis. The stimulus recorded by the software during that five minute
adjustment period can be discarded by omitting that stimulus number from the
\code{stimulus.keep} argument.

This function will also append an item to your list of data frames that
contains the relevant column names to be retained in future manipulations of
the data.
}
\examples{
 servosphere <- list(data.frame(id = rep(1, 200),
                                stimulus = rep(c(0, 1), each = 100),
                                dT = sample(8:12, 200, replace = TRUE),
                                dx = runif(200, 0, 5),
                                dy = runif(200, 0, 5),
                                treatment = rep("a", 200),
                                date = rep("2032018", 200)),
                     data.frame(id = rep(2, 200),
                                stimulus = rep(c(0, 1), each = 100),
                                dT = sample(8:12, 200, replace = TRUE),
                                dx = runif(200, 0, 5),
                                dy = runif(200, 0, 5),
                                treatment = rep("b", 200),
                                date = rep("2032018", 200)))
 trial_record <- data.frame(id = c(1, 2),
                            treatment = c("a", "b"),
                            date = c("2032018", "2042018"),
                            time = c("13:30", "07:30"))
 trial_id_split <- data.frame(id = c(1, 2, 1, 2),
                              stimulus = c(1, 1, 2, 2),
                              treatment = c("a", "b", "a", "b"),
                              date = rep(c("2032018", "2042018"), times = 2),
                              time = rep(c("13:30", "07:30"), times = 2),
                              id_stim = c("1_1", "2_1", "1_2", "2_2"))
# Merge the columns id, treatment, and date from the trial_record data frame
# with all the data frames in our list servosphere.

 merged_servosphere <- mergeTrialInfo(servosphere,
   trial_record,
   col.names = c("id", "treatment"),
   stimulus.keep = c(0, 1))

# Repeat of the merger above without retaining the id column while
# also splitting the data provided into separate data frames based on the
# different stimuli recorded, keeping only data associated with stimuli 1 and
# 2. Splitting based on stimulus requires a column in the trial.data data
# frame titled id_stim.

 merged_servosphere <- mergeTrialInfo(servosphere,
     trial_id_split,
     col.names = c("id", "treatment"),
     stimulus.split = TRUE,
     stimulus.keep = c(0, 1))
}
