% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summarize_variables.R
\name{summaryTotalDistance}
\alias{summaryTotalDistance}
\title{Calculate total path distance}
\usage{
summaryTotalDistance(list, summary.df = NA)
}
\arguments{
\item{list}{A list of data frames, each of which has a column recording the
distance moved during each recording period.}

\item{summary.df}{The data frame object within which you are storing path
summary variables. The default is NA if you do not currently have a summary
data frame object started. When set to NA the function will create a new
summary data frame. When an object is provided, the function will merge the
summary data frame with the new data.}
}
\value{
A named vector of numbers where each number corresponds to the total
  distance moved by an organism represented in the list of data frames. The
  numbers are ordered and named as they are in the data frames list.
}
\description{
Calculate the total distance moved by an organism on the servosphere
}
\details{
Determine the total distance of a path taken by an organism on a servosphere.
}
\examples{
# If a summary data frame has not been started

 servosphere <- list(data.frame(id = rep(1, 200),
                                stimulus = rep(c(0, 1), each = 100),
                                dT = sample(8:12, 200, replace = TRUE),
                                dx = runif(200, 0, 5),
                                dy = runif(200, 0, 5),
                                treatment = rep("a", 200),
                                date = rep("2032018", 200)),
                     data.frame(id = rep(2, 200),
                                stimulus = rep(c(0, 1), each = 100),
                                dT = sample(8:12, 200, replace = TRUE),
                                dx = runif(200, 0, 5),
                                dy = runif(200, 0, 5),
                                treatment = rep("b", 200),
                                date = rep("2032018", 200)))

servosphere <- calcDistance(servosphere)

summary_df <- summaryTotalDistance(servosphere, summary.df = NA)

# If a summary data frame has been started

summary_df <- data.frame(id = c(1, 2),
                         treatment = c("a", "b"),
                         date = c("2032018", "2042018"),
                         stimulus = c(0, 0))

summary_df <- summaryTotalDistance(servosphere, summary.df = summary_df)

}
