% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Set_Interval.R
\name{isSubinterval}
\alias{isSubinterval}
\title{Test If Two Intervals Are Subintervals}
\arguments{
\item{x}{\link{Set} or \code{list}}

\item{proper}{If \code{TRUE} then tests if \code{x} is a proper subinterval (i.e. subinterval and not equal to)
of \code{self}, otherwise \code{FALSE} tests if \code{x} is a (non-proper) subinterval.}

\item{all}{If \code{TRUE} then returns \code{TRUE} if all \code{x} are subintervals, otherwise returns a vector of logicals.}
}
\value{
If \code{all} is \code{TRUE} then returns \code{TRUE} if all \code{x} are subsets of the Set, otherwise
\code{FALSE}. If \code{all} is \code{FALSE} then returns a vector of logicals corresponding to each individual
element of \code{x}.
}
\description{
Test If Two Intervals Are Subintervals
}
\details{
If \code{x} is a \link{Set} then will be coerced to an \link{Interval} if possible. \link{isSubinterval} differs
from \link{isSubset} in that ordering and class are respected in \link{isSubinterval}. See examples for
a clearer illustration of the difference.
}
\section{R6 Usage}{
 $isSubinterval(x, proper = FALSE, all = FALSE)
}

\examples{
Interval$new(1,3)$isSubset(Set$new(1,2)) # TRUE
Interval$new(1,3)$isSubset(Set$new(2, 1)) # TRUE
Interval$new(1,3, class = "integer")$isSubinterval(Set$new(1, 2)) # TRUE
Interval$new(1,3)$isSubinterval(Set$new(1, 2)) # FALSE
Interval$new(1,3)$isSubinterval(Set$new(2, 1)) # FALSE

Reals$new()$isSubset(Integers$new()) # TRUE
Reals$new()$isSubinterval(Integers$new()) # FALSE
}
\seealso{
\link{isSubset}
}
