% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/assertions.R
\name{testClosed}
\alias{testClosed}
\alias{checkClosed}
\alias{assertClosed}
\title{assert/check/test/Closed}
\usage{
testClosed(object, errormsg = "This is not a closed set")

checkClosed(object, errormsg = "This is not a closed set")

assertClosed(object, errormsg = "This is not a closed set")
}
\arguments{
\item{object}{object to test}

\item{errormsg}{error message to overwrite default if check fails}
}
\value{
If check passes then \code{assert} returns \code{object} invisibly and \code{test}/\code{check}
return \code{TRUE}. If check fails, \code{assert} stops code with error, \code{check} returns
an error message as string, and \code{test} returns \code{FALSE}.
}
\description{
Validation checks to test if a given object is closed.
}
\examples{
testClosed(Interval$new(1, 10, type = "[]"))
testClosed(Interval$new(1, 10, type = "(]"))
}
