% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/grid.R
\name{st_viewport}
\alias{st_viewport}
\title{Create viewport from sf, sfc or sfg object}
\usage{
st_viewport(x, ..., bbox = st_bbox(x), asp)
}
\arguments{
\item{x}{object of class sf, sfc or sfg object}

\item{...}{parameters passed on to \link[grid]{viewport}}

\item{bbox}{the bounding box used for aspect ratio}

\item{asp}{numeric; target aspect ratio (y/x), see Details}
}
\value{
the output of the call to \link[grid]{viewport}
}
\description{
Create viewport from sf, sfc or sfg object
}
\details{
parameters width, height, xscale and yscale are set such that aspect ratio is honoured and plot size is maximized in the current viewport; others can be passed as ...

if \code{asp} is missing, it is taken as 1, except when \code{isTRUE(st_is_longlat(x))}, in which case it is set to \code{1.0 /cos(y)}, with \code{y} the middle of the latitude bounding box.
}
\examples{
library(grid)
nc = st_read(system.file("shape/nc.shp", package="sf"), "nc", crs = 4267)
grid.newpage()
pushViewport(viewport(width = 0.8, height = 0.8))
pushViewport(st_viewport(nc))
invisible(lapply(st_geometry(nc), function(x) grid.draw(st_as_grob(x, gp = gpar(fill = 'red')))))
}

