% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tidy.R, R/join.R
\name{dplyr}
\alias{anti_join.sf}
\alias{arrange_.sf}
\alias{distinct_.sf}
\alias{dplyr}
\alias{filter_.sf}
\alias{full_join.sf}
\alias{gather_.sf}
\alias{group_by_.sf}
\alias{inner_join.sf}
\alias{left_join.sf}
\alias{mutate_.sf}
\alias{rename_.sf}
\alias{right_join.sf}
\alias{select_.sf}
\alias{semi_join.sf}
\alias{slice_.sf}
\alias{spread_.sf}
\alias{summarise_.sf}
\alias{transmute_.sf}
\title{Dplyr verb methods for sf objects}
\usage{
filter_.sf(.data, ..., .dots)

arrange_.sf(.data, ..., .dots)

distinct_.sf(.data, ..., .dots, .keep_all = FALSE)

group_by_.sf(.data, ..., .dots, add = FALSE)

mutate_.sf(.data, ..., .dots)

transmute_.sf(.data, ..., .dots)

select_.sf(.data, ..., .dots = NULL)

rename_.sf(.data, ..., .dots)

slice_.sf(.data, ..., .dots)

summarise_.sf(.data, ..., .dots)

gather_.sf(data, key_col, value_col, gather_cols, na.rm = FALSE,
  convert = FALSE, factor_key = FALSE)

spread_.sf(data, key_col, value_col, fill = NA, convert = FALSE,
  drop = TRUE, sep = NULL)

inner_join.sf(x, y, by = NULL, copy = FALSE, suffix = c(".x", ".y"), ...)

left_join.sf(x, y, by = NULL, copy = FALSE, suffix = c(".x", ".y"), ...)

right_join.sf(x, y, by = NULL, copy = FALSE, suffix = c(".x", ".y"), ...)

full_join.sf(x, y, by = NULL, copy = FALSE, suffix = c(".x", ".y"), ...)

semi_join.sf(x, y, by = NULL, copy = FALSE, ...)

anti_join.sf(x, y, by = NULL, copy = FALSE, ...)
}
\arguments{
\item{.data}{data object of class \link{sf}}

\item{...}{other arguments}

\item{.dots}{see corresponding function in package \code{dplyr}}

\item{.keep_all}{see corresponding function in dplyr}

\item{add}{see corresponding function in dplyr}

\item{data}{see original function docs}

\item{key_col}{see original function docs}

\item{value_col}{see original function docs}

\item{gather_cols}{see original function docs}

\item{na.rm}{see original function docs}

\item{convert}{see original function docs}

\item{factor_key}{see original function docs}

\item{fill}{see original function docs}

\item{drop}{see original function docs}

\item{sep}{see original function docs}

\item{x}{see \link[dplyr]{left_join}}

\item{y}{see \link[dplyr]{left_join}}

\item{by}{see \link[dplyr]{left_join}}

\item{copy}{see \link[dplyr]{left_join}}

\item{suffix}{see \link[dplyr]{left_join}}
}
\description{
Dplyr verb methods for sf objects
}
\examples{
library(dplyr)
nc = st_read(system.file("shape/nc.shp", package="sf"))
nc \%>\% filter(AREA > .1) \%>\% plot()
# plot 10 smallest counties in grey:
st_geometry(nc) \%>\% plot()
nc \%>\% select(AREA) \%>\% arrange(AREA) \%>\% slice(1:10) \%>\% plot(add = TRUE, col = 'grey')
title("the ten counties with smallest area")
nc[c(1:100, 1:10), ] \%>\% distinct() \%>\% nrow()
nc$area_cl = cut(nc$AREA, c(0, .1, .12, .15, .25))
nc \%>\% group_by(area_cl) \%>\% class()
nc2 <- nc \%>\% mutate(area10 = AREA/10)
nc \%>\% transmute(AREA = AREA/10, geometry = geometry) \%>\% class()
nc \%>\% transmute(AREA = AREA/10) \%>\% class()
nc \%>\% select(SID74, SID79) \%>\% names()
nc \%>\% select(SID74, SID79, geometry) \%>\% names()
nc \%>\% select(SID74, SID79) \%>\% class()
nc \%>\% select(SID74, SID79, geometry) \%>\% class()
nc2 <- nc \%>\% rename(area = AREA)
nc \%>\% slice(1:2)
nc$area_cl = cut(nc$AREA, c(0, .1, .12, .15, .25))
nc.g <- nc \%>\% group_by(area_cl)
nc.g \%>\% summarise(mean(AREA))
nc.g \%>\% summarize(mean(AREA))
nc.g \%>\% summarize(mean(AREA)) \%>\% plot(col = grey(3:6 / 7))
library(tidyr)
nc \%>\% select(SID74, SID79, geometry) \%>\% gather(VAR, SID, -geometry) \%>\% summary()
library(tidyr)
nc$row = 1:100 # needed for spread to work
nc \%>\% select(SID74, SID79, geometry, row) \%>\% 
     gather(VAR, SID, -geometry, -row) \%>\% 
	spread(VAR, SID) \%>\% head()
}

