% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tidyverse.R, R/join.R
\name{dplyr}
\alias{dplyr}
\alias{filter_.sf}
\alias{dplyr}
\alias{filter.sf}
\alias{dplyr}
\alias{arrange_.sf}
\alias{dplyr}
\alias{arrange.sf}
\alias{dplyr}
\alias{distinct_.sf}
\alias{dplyr}
\alias{distinct.sf}
\alias{dplyr}
\alias{group_by_.sf}
\alias{dplyr}
\alias{group_by.sf}
\alias{dplyr}
\alias{ungroup.sf}
\alias{dplyr}
\alias{mutate_.sf}
\alias{dplyr}
\alias{mutate.sf}
\alias{dplyr}
\alias{transmute_.sf}
\alias{dplyr}
\alias{transmute.sf}
\alias{dplyr}
\alias{select_.sf}
\alias{dplyr}
\alias{select.sf}
\alias{dplyr}
\alias{rename_.sf}
\alias{dplyr}
\alias{rename.sf}
\alias{dplyr}
\alias{slice_.sf}
\alias{dplyr}
\alias{slice.sf}
\alias{dplyr}
\alias{summarise.sf}
\alias{summarise}
\alias{dplyr}
\alias{summarise_.sf}
\alias{dplyr}
\alias{gather_.sf}
\alias{dplyr}
\alias{spread_.sf}
\alias{dplyr}
\alias{sample_n.sf}
\alias{dplyr}
\alias{sample_frac.sf}
\alias{dplyr}
\alias{nest_.sf}
\alias{dplyr}
\alias{separate_.sf}
\alias{dplyr}
\alias{unite_.sf}
\alias{dplyr}
\alias{inner_join.sf}
\alias{dplyr}
\alias{left_join.sf}
\alias{dplyr}
\alias{right_join.sf}
\alias{dplyr}
\alias{full_join.sf}
\alias{dplyr}
\alias{semi_join.sf}
\alias{dplyr}
\alias{anti_join.sf}
\title{Dplyr verb methods for sf objects}
\usage{
filter_.sf(.data, ..., .dots)

filter.sf(.data, ..., .dots)

arrange_.sf(.data, ..., .dots)

arrange.sf(.data, ..., .dots)

distinct_.sf(.data, ..., .dots, .keep_all = FALSE)

distinct.sf(.data, ..., .dots, .keep_all = FALSE)

group_by_.sf(.data, ..., .dots, add = FALSE)

group_by.sf(.data, ..., .dots, add = FALSE)

ungroup.sf(x, ...)

mutate_.sf(.data, ..., .dots)

mutate.sf(.data, ..., .dots)

transmute_.sf(.data, ..., .dots)

transmute.sf(.data, ..., .dots)

select_.sf(.data, ..., .dots = NULL)

select.sf(.data, ...)

rename_.sf(.data, ..., .dots)

rename.sf(.data, ..., .dots)

slice_.sf(.data, ..., .dots)

slice.sf(.data, ..., .dots)

summarise.sf(.data, ..., .dots, do_union = TRUE)

summarise_.sf(.data, ..., .dots, do_union = TRUE)

gather_.sf(data, key_col, value_col, gather_cols, na.rm = FALSE,
  convert = FALSE, factor_key = FALSE)

spread_.sf(data, key_col, value_col, fill = NA, convert = FALSE,
  drop = TRUE, sep = NULL)

sample_n.sf(tbl, size, replace = FALSE, weight = NULL,
  .env = parent.frame())

sample_frac.sf(tbl, size = 1, replace = FALSE, weight = NULL,
  .env = parent.frame())

nest_.sf(data, key_col, nest_cols)

separate_.sf(data, col, into, sep = "[^[:alnum:]]+", remove = TRUE,
  convert = FALSE, extra = "warn", fill = "warn", ...)

unite_.sf(data, col, from, sep = "_", remove = TRUE)

inner_join.sf(x, y, by = NULL, copy = FALSE, suffix = c(".x", ".y"), ...)

left_join.sf(x, y, by = NULL, copy = FALSE, suffix = c(".x", ".y"), ...)

right_join.sf(x, y, by = NULL, copy = FALSE, suffix = c(".x", ".y"), ...)

full_join.sf(x, y, by = NULL, copy = FALSE, suffix = c(".x", ".y"), ...)

semi_join.sf(x, y, by = NULL, copy = FALSE, ...)

anti_join.sf(x, y, by = NULL, copy = FALSE, ...)
}
\arguments{
\item{.data}{data object of class \link{sf}}

\item{...}{other arguments}

\item{.dots}{see corresponding function in package \code{dplyr}}

\item{.keep_all}{see corresponding function in dplyr}

\item{add}{see corresponding function in dplyr}

\item{x}{see \link[dplyr]{left_join}}

\item{do_union}{logical; should geometries be unioned by using \link{st_union}, or simply be combined using \link{st_combine}? Using \link{st_union} resolves internal boundaries, but in case of unioning points may also change the order of the points.}

\item{data}{see original function docs}

\item{key_col}{see original function docs}

\item{value_col}{see original function docs}

\item{gather_cols}{see original function docs}

\item{na.rm}{see original function docs}

\item{convert}{see original function docs}

\item{factor_key}{see original function docs}

\item{fill}{see original function docs}

\item{drop}{see original function docs}

\item{sep}{see original function docs}

\item{tbl}{see original function docs}

\item{size}{see original function docs}

\item{replace}{see original function docs}

\item{weight}{see original function docs}

\item{.env}{see original function docs}

\item{nest_cols}{see \link[tidyr]{nest}}

\item{col}{see \link[tidyr]{separate}}

\item{into}{see \link[tidyr]{separate}}

\item{remove}{see \link[tidyr]{separate}}

\item{extra}{see \link[tidyr]{separate}}

\item{from}{see \link[tidyr]{unite}}

\item{y}{see \link[dplyr]{left_join}}

\item{by}{see \link[dplyr]{left_join}}

\item{copy}{see \link[dplyr]{left_join}}

\item{suffix}{see \link[dplyr]{left_join}}
}
\description{
Dplyr verb methods for sf objects. Geometries are sticky, use \link{as.data.frame} to let code{dplyr}'s own methods drop them.
}
\details{
\code{select} keeps the geometry regardless whether it is selected or not; to deselect it, first pipe through \code{as.data.frame} to let dplyr's own \code{select} drop it.
}
\examples{
library(dplyr)
nc = st_read(system.file("shape/nc.shp", package="sf"))
nc \%>\% filter(AREA > .1) \%>\% plot()
# plot 10 smallest counties in grey:
st_geometry(nc) \%>\% plot()
nc \%>\% select(AREA) \%>\% arrange(AREA) \%>\% slice(1:10) \%>\% plot(add = TRUE, col = 'grey')
title("the ten counties with smallest area")
nc[c(1:100, 1:10), ] \%>\% distinct() \%>\% nrow()
nc$area_cl = cut(nc$AREA, c(0, .1, .12, .15, .25))
nc \%>\% group_by(area_cl) \%>\% class()
nc2 <- nc \%>\% mutate(area10 = AREA/10)
nc \%>\% transmute(AREA = AREA/10, geometry = geometry) \%>\% class()
nc \%>\% transmute(AREA = AREA/10) \%>\% class()
nc \%>\% select(SID74, SID79) \%>\% names()
nc \%>\% select(SID74, SID79, geometry) \%>\% names()
nc \%>\% select(SID74, SID79) \%>\% class()
nc \%>\% select(SID74, SID79, geometry) \%>\% class()
nc2 <- nc \%>\% rename(area = AREA)
nc \%>\% slice(1:2)
nc$area_cl = cut(nc$AREA, c(0, .1, .12, .15, .25))
nc.g <- nc \%>\% group_by(area_cl)
nc.g \%>\% summarise(mean(AREA))
nc.g \%>\% summarise(mean(AREA)) \%>\% plot(col = grey(3:6 / 7))
nc \%>\% as.data.frame \%>\% summarise(mean(AREA))
library(tidyr)
nc \%>\% select(SID74, SID79, geometry) \%>\% gather(VAR, SID, -geometry) \%>\% summary()
library(tidyr)
nc$row = 1:100 # needed for spread to work
nc \%>\% select(SID74, SID79, geometry, row) \%>\% 
	gather(VAR, SID, -geometry, -row) \%>\% 
	spread(VAR, SID) \%>\% head()
}
