% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sfc.R
\name{sfc}
\alias{sfc}
\alias{st_sfc}
\title{Create simple feature geometry list column}
\usage{
st_sfc(..., crs = NA_crs_, precision = 0)
}
\arguments{
\item{...}{zero or more simple feature geometries (objects of class \code{sfg}), or a single list of such objects; \code{NULL} values will get replaced by empty geometries.}

\item{crs}{coordinate reference system: integer with the EPSG code, or character with proj4string}

\item{precision}{numeric; see \link{st_as_binary}}
}
\value{
an object of class \code{sfc}, which is a classed list-column with simple feature geometries.
}
\description{
Create simple feature geometry list column, set class, and add coordinate reference system and precision
}
\details{
A simple feature geometry list-column is a list of class
\code{c("stc_TYPE", "sfc")} which most often contains objects of identical type; 
in case of a mix of types or an empty set, \code{TYPE} is set to the 
superclass \code{GEOMETRY}.
}
\examples{
pt1 = st_point(c(0,1))
pt2 = st_point(c(1,1))
(sfc = st_sfc(pt1, pt2))
d = st_sf(data.frame(a=1:2, geom=sfc))
}
