% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/st_arrow.R
\name{st_write_parquet}
\alias{st_write_parquet}
\title{Write \code{sf} object to Parquet file}
\usage{
st_write_parquet(obj, dsn, ...)
}
\arguments{
\item{obj}{object of class \code{\link[sf]{sf}}}

\item{dsn}{data source name. A path and file name with .parquet extension}

\item{...}{additional options to pass to \code{\link[arrow]{write_parquet}}}
}
\value{
\code{obj} invisibly
}
\description{
Convert a simple features spatial object from \code{sf} and
write to a Parquet file using \code{\link[arrow]{write_parquet}}. Geometry
columns (type \code{sfc}) are converted to well-known binary (WKB) format.
}
\examples{
nc <- sf::st_read(system.file("shape/nc.shp", package="sf"), quiet = TRUE)

st_write_parquet(obj=nc, dsn=file.path(tempdir(), "nc.parquet"))

# In Python, read the new file with geopandas.read_parquet(...)

nc_p <- st_read_parquet(file.path(tempdir(), "nc.parquet"))

}
\seealso{
\code{\link[arrow]{write_parquet}}
}
