% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/update_values.R
\name{update_values}
\alias{update_values}
\title{Update the Values of a Design}
\usage{
update_values(design, values)
}
\arguments{
\item{design}{A tibble produced by \code{\link[=get_design]{get_design()}}. The column values should
be unmodified.}

\item{values}{A list of vectors containing the possible values for each
parameter. There should be as many values (of any type) as there are rows in
\code{design}. For numeric data, it is preferable that the values are equally
spaced.}
}
\value{
An updated tibble.
}
\description{
For a set of values, this function inserts the actual values of the design
produced by \code{\link[=get_design]{get_design()}}.
}
\examples{
des <- get_design(3, 6)
des

vals <- list(1:6, letters[1:6], seq(20, 21, length.out = 6))

des_2 <- update_values(des, vals)
des_2
}
