% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/joincount-bv-impl.R
\name{local_jc_bv}
\alias{local_jc_bv}
\title{Bivariate local join count}
\usage{
local_jc_bv(x, z, nb, wt, nsim = 499)
}
\arguments{
\item{x}{a binary variable either numeric or logical}

\item{z}{a binary variable either numeric or logical}

\item{nb}{a neighbors list object.}

\item{wt}{default \code{st_weights(nb, style = "B")}. A binary weights list as created by \code{st_weights(nb, style = "B")}.}

\item{nsim}{the number of conditional permutation simulations}
}
\value{
a \code{data.frame} with two columns \code{join_count} and \code{p_sim} and number of rows equal to the length of arguments \code{x}, \code{z}, \code{nb}, and \code{wt}.
}
\description{
Bivariate local join count
}
\examples{
x <- as.integer(guerry$infants > 23574)
z <- as.integer(guerry$donations > 10973)
nb <- st_contiguity(guerry)
wt <- st_weights(nb, style = "B")
local_jc_bv(x, z, nb, wt)
}
