% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/weights-contiguity.R
\name{st_weights}
\alias{st_weights}
\title{Calculate spatial weights}
\usage{
st_weights(nb, style = "W", allow_zero = NULL, ...)
}
\arguments{
\item{nb}{A neighbor list object as created by \code{st_neighbors()}.}

\item{style}{Default \code{"W"} for row standardized weights. This value can also be "B", "C", "U", "minmax", and "S". See \code{\link[spdep:nb2listw]{spdep::nb2listw()}} for details.}

\item{allow_zero}{If \code{TRUE}, assigns zero as lagged value to zone without neighbors.}

\item{...}{additional arguments passed to \code{\link[spdep:nb2listw]{spdep::nb2listw()}}.}
}
\value{
a list where each element is a numeric vector
}
\description{
Calculate polygon spatial weights from a \code{nb} list. See \code{\link[spdep:nb2listw]{spdep::nb2listw()}} for further details.
}
\details{
Under the hood, \code{\link[=st_weights]{st_weights()}} creates a \code{listw} object and then extracts the weights elements from it as the \code{neighbours} element is already--presumably--already existent in the neighbors list you've already created. \code{listw} objects are recreated using \code{\link[=recreate_listw]{recreate_listw()}} when calculating other statistics.
}
\examples{
library(magrittr)
guerry \%>\%
 dplyr::mutate(nb = st_contiguity(geometry),
               wt = st_weights(nb),
               .before = 1)

# using geometry column directly
nb <- st_contiguity(guerry$geometry)
wt <- st_weights(nb)
wt[1:3]
}
\seealso{
Other weights: 
\code{\link{st_inverse_distance}()},
\code{\link{st_kernel_weights}()},
\code{\link{st_nb_dists}()}
}
\concept{weights}
