% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/losh.R
\name{losh}
\alias{losh}
\alias{losh_perm}
\title{Local spatial heteroscedacity}
\usage{
losh(x, nb, wt, a = 2, ...)

losh_perm(x, nb, wt, a = 2, nsim = 499, ...)
}
\arguments{
\item{x}{a numeric vector.}

\item{nb}{a neighbor list for example created by \code{\link[=st_contiguity]{st_contiguity()}}}

\item{wt}{a weights list for example created by \code{\link[=st_weights]{st_weights()}}}

\item{a}{the exponent applied to the local residuals}

\item{...}{methods passed to \link[spdep:LOSH]{spdep::LOSH}}

\item{nsim}{number of simulations to run}
}
\value{
a \code{data.frame} with columns
\itemize{
\item \code{hi}: the observed statistic
\item \code{e_hi}: the sample average
\item \code{var_hi}: the sample variance
\item \code{z_hi} the approximately Chi-square distributed test statistic
\item \code{x_bar_i}: the local spatially weight mean for observation \code{i}
\item \code{ei}: residuals
}
}
\description{
Local spatial heteroscedacity
}
\examples{
nb <- st_contiguity(guerry)
wt <- st_weights(nb)
x <- guerry$crime_pers
losh(x, nb, wt)
losh(x, nb, wt, var_hi = FALSE)
losh_perm(x, nb, wt, nsim = 49)
}
