% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sfn-node-get.R
\name{node_get_nbs}
\alias{node_get_nbs}
\alias{node_get_edge_list}
\alias{node_get_edge_col}
\title{Create node features from edges}
\usage{
node_get_nbs()

node_get_edge_list()

node_get_edge_col(edges, .var)
}
\arguments{
\item{edges}{an edge list as created by \code{node_get_edge_list()}}

\item{.var}{the quoted name of a column in the edge context.}
}
\value{
A list column
}
\description{
Given a tidygraph object, create a list column of edge data for each node in the node context.
}
\details{
\itemize{
\item \code{node_get_nbs()}: creates a neighbor list in the nodes context based on the adjacency list. This returns a \code{nb} class object with the \emph{neighboring nodes}.
\itemize{
\item Uses \code{igraph::get.adjlist()}
}
\item \code{node_get_edge_list()}: creates an edge list. The edge list contains the row index of the edge relationships in the edge context for each node.
\itemize{
\item Uses \code{igraph::get.adjedgelist()}.
}
\item \code{node_get_edge_col()}: creates a list column containing edge attributes as a list column in the node context (much like \code{find_xj()}).
\itemize{
\item Uses \code{igraph::get.edge.attribute()}
}
}
}
\examples{

if (interactive()) {
  net <- sfnetworks::as_sfnetwork(
    sfnetworks::roxel
  )

  dplyr::mutate(
    net,
    nb = node_get_nbs(),
    edges = node_get_edge_list(),
    types = node_get_edge_col(edges, "type")
  )
}
}
\concept{sfnetworks}
