# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' @title Check if OpenMP is enabled
#' 
#' @description
#' Internal function to check if OpenMP is enabled
#' 
#' @keywords internal
omp.check <- function() {
    .Call(`_sgdGMF_omp_check`)
}

#' @title Compute one Fisher scoring step for GLMs
#' 
#' @description
#' Internal function to compute one Fisher scoring step for GLMs.
#' It constitutes the building block of the AIRWLS algorithm for the
#' estimation of GMF models.
#' 
#' @param beta current value of the regression coefficients to be updated
#' @param y response vector
#' @param X design matrix
#' @param familyname model family name
#' @param linkname link function name
#' @param varfname variance function name
#' @param offset vector of constants to be added to the linear predictor
#' @param weights vector of constants non-negative weights
#' @param penalty penalty parameter of a ridge-type penalty
#' 
#' @keywords internal
cpp.airwls.glmstep <- function(beta, y, X, familyname, linkname, varfname, offset, weights, penalty) {
    .Call(`_sgdGMF_cpp_airwls_glmstep`, beta, y, X, familyname, linkname, varfname, offset, weights, penalty)
}

#' @title Fisher scoring algorithm for GLMs
#' 
#' @description
#' Internal function implementing the Fisher scoring algorithms for the
#' estimation of GLMs. It is used in the AIRWLS algorithm for the 
#' estimation of GMF models.
#' 
#' @param beta initial value of the regression coefficients to be estimated
#' @param y response vector
#' @param X design matrix
#' @param familyname model family name
#' @param linkname link function name
#' @param varfname variance function name
#' @param offset vector of constants to be added to the linear predictor
#' @param weights vector of constants non-negative weights
#' @param penalty penalty parameter of a ridge-type penalty
#' @param nsteps number of iterations
#' @param stepsize stepsize parameter of the Fisher scoring algorithm
#' @param print if \code{TRUE}, print the algorithm history
#' 
#' @keywords internal
cpp.airwls.glmfit <- function(beta, y, X, familyname, linkname, varfname, offset, weights, penalty, nsteps = 100L, stepsize = 0.1, print = FALSE) {
    .Call(`_sgdGMF_cpp_airwls_glmfit`, beta, y, X, familyname, linkname, varfname, offset, weights, penalty, nsteps, stepsize, print)
}

#' @title AIRWLS update for GMF models
#' 
#' @description
#' Internal function implementing one step of AIRWLS for the
#' estimation of GMF models. 
#' 
#' @param beta initial value of the regression coefficients to be estimated
#' @param Y response vector
#' @param X design matrix
#' @param familyname model family name
#' @param linkname link function name
#' @param varfname variance function name
#' @param idx index identifying the parameters to be updated in \code{beta}
#' @param offset vector of constants to be added to the linear predictor
#' @param weights vector of constants non-negative weights
#' @param penalty penalty parameter of a ridge-type penalty
#' @param transp if \code{TRUE}, transpose the data
#' @param nsteps number of iterations
#' @param stepsize stepsize parameter of the Fisher scoring algorithm
#' @param print if \code{TRUE}, print the algorithm history
#' @param parallel if \code{TRUE}, run the updates in parallel using \code{openMP}
#' @param nthreads number of threads to be run in parallel (only if \code{parallel=TRUE})
#' 
#' @keywords internal
cpp.airwls.update <- function(beta, Y, X, familyname, linkname, varfname, idx, offset, weights, penalty, transp = FALSE, nsteps = 100L, stepsize = 0.1, print = FALSE, parallel = FALSE, nthreads = 1L) {
    .Call(`_sgdGMF_cpp_airwls_update`, beta, Y, X, familyname, linkname, varfname, idx, offset, weights, penalty, transp, nsteps, stepsize, print, parallel, nthreads)
}

#' @title Fit a GMF model using the AIRWLS algorithm
#'
#' @description Fit a GMF model using the AIRWLS algorithm
#'
#' @param Y matrix of responses (\eqn{n \times m})
#' @param X matrix of row fixed effects (\eqn{n \times p})
#' @param B initial row-effect matrix (\eqn{n \times p})
#' @param A initial column-effect matrix (\eqn{n \times q})
#' @param Z matrix of column fixed effects (\eqn{m \times q})
#' @param U initial factor matrix (\eqn{n \times d})
#' @param V initial loading matrix (\eqn{m \times d})
#' @param O matrix of constant offset (\eqn{n \times m})
#' @param W matrix of constant weights (\eqn{n \times m})
#' @param familyname a \code{glm} model family name
#' @param linkname a \code{glm} link function name
#' @param varfname variance function name
#' @param ncomp rank of the latent matrix factorization
#' @param lambda penalization parameters
#' @param maxiter maximum number of iterations
#' @param nsteps number of inner Fisher scoring iterations
#' @param stepsize stepsize of the inner Fisher scoring algorithm
#' @param eps shrinkage factor for extreme predictions
#' @param nafill how often the missing values are updated
#' @param tol tolerance threshold for the stopping criterion
#' @param damping diagonal dumping factor for the Hessian matrix
#' @param verbose if \code{TRUE}, print the optimization status
#' @param frequency how often the optimization status is printed
#' @param parallel if \code{TRUE}, allows for parallel computing
#' @param nthreads number of cores to be used in parallel
#'
#' @keywords internal
cpp.fit.airwls <- function(Y, X, B, A, Z, U, V, O, W, familyname, linkname, varfname, ncomp, lambda, maxiter = 500L, nsteps = 1L, stepsize = 0.1, eps = 1e-08, nafill = 1L, tol = 1e-05, damping = 1e-03, verbose = TRUE, frequency = 10L, parallel = FALSE, nthreads = 1L) {
    .Call(`_sgdGMF_cpp_fit_airwls`, Y, X, B, A, Z, U, V, O, W, familyname, linkname, varfname, ncomp, lambda, maxiter, nsteps, stepsize, eps, nafill, tol, damping, verbose, frequency, parallel, nthreads)
}

#' @title Fit a GMF model using the diagonal quasi-Newton algorithm
#'
#' @description Fit a GMF model using the diagonal quasi-Newton algorithm
#'
#' @param Y matrix of responses (\eqn{n \times m})
#' @param X matrix of row fixed effects (\eqn{n \times p})
#' @param B initial row-effect matrix (\eqn{n \times p})
#' @param A initial column-effect matrix (\eqn{n \times q})
#' @param Z matrix of column fixed effects (\eqn{m \times q})
#' @param U initial factor matrix (\eqn{n \times d})
#' @param V initial loading matrix (\eqn{m \times d})
#' @param O matrix of constant offset (\eqn{n \times m})
#' @param W matrix of constant weights (\eqn{n \times m})
#' @param familyname a \code{glm} model family name
#' @param linkname a \code{glm} link function name
#' @param varfname variance function name
#' @param ncomp rank of the latent matrix factorization
#' @param lambda penalization parameters
#' @param maxiter maximum number of iterations
#' @param stepsize stepsize of the quasi-Newton update
#' @param eps shrinkage factor for extreme predictions
#' @param nafill how often the missing values are updated
#' @param tol tolerance threshold for the stopping criterion
#' @param damping diagonal dumping factor for the Hessian matrix
#' @param verbose if \code{TRUE}, print the optimization status
#' @param frequency how often the optimization status is printed
#' @param parallel if \code{TRUE}, allows for parallel computing
#' @param nthreads number of cores to be used in parallel
#'
#' @keywords internal
cpp.fit.newton <- function(Y, X, B, A, Z, U, V, O, W, familyname, linkname, varfname, ncomp, lambda, maxiter = 500L, stepsize = 0.1, eps = 1e-08, nafill = 1L, tol = 1e-05, damping = 1e-03, verbose = TRUE, frequency = 10L, parallel = FALSE, nthreads = 1L) {
    .Call(`_sgdGMF_cpp_fit_newton`, Y, X, B, A, Z, U, V, O, W, familyname, linkname, varfname, ncomp, lambda, maxiter, stepsize, eps, nafill, tol, damping, verbose, frequency, parallel, nthreads)
}

#' @title Fit a GMF model using the adaptive SGD with coordinate-wise minibatch subsampling algorithm
#'
#' @description Fit a GMF model using the adaptive SGD with coordinate-wise minibatch subsampling algorithm
#'
#' @param Y matrix of responses (\eqn{n \times m})
#' @param X matrix of row fixed effects (\eqn{n \times p})
#' @param B initial row-effect matrix (\eqn{n \times p})
#' @param A initial column-effect matrix (\eqn{n \times q})
#' @param Z matrix of column fixed effects (\eqn{m \times q})
#' @param U initial factor matrix (\eqn{n \times d})
#' @param V initial loading matrix (\eqn{m \times d})
#' @param O matrix of constant offset (\eqn{n \times m})
#' @param W matrix of constant weights (\eqn{n \times m})
#' @param familyname a \code{glm} model family name
#' @param linkname a \code{glm} link function name
#' @param varfname variance function name
#' @param ncomp rank of the latent matrix factorization
#' @param lambda penalization parameters
#' @param maxiter maximum number of iterations
#' @param eps shrinkage factor for extreme predictions
#' @param nafill how often the missing values are updated
#' @param tol tolerance threshold for the stopping criterion
#' @param size1 row-minibatch dimension
#' @param size2 column-minibatch dimension
#' @param burn burn-in period in which the learning late is not decreased
#' @param rate0 initial learning rate
#' @param decay decay rate of the learning rate
#' @param damping diagonal dumping factor for the Hessian matrix
#' @param rate1 decay rate of the first moment estimate of the gradient
#' @param rate2 decay rate of the second moment estimate of the gradient
#' @param parallel if \code{TRUE}, allows for parallel computing
#' @param nthreads number of cores to be used in parallel
#' @param verbose if \code{TRUE}, print the optimization status
#' @param frequency how often the optimization status is printed
#' @param progress if \code{TRUE}, print an progress bar
#' 
#' @keywords internal
cpp.fit.coord.sgd <- function(Y, X, B, A, Z, U, V, O, W, familyname, linkname, varfname, ncomp, lambda, maxiter = 1000L, eps = 0.01, nafill = 10L, tol = 1e-08, size1 = 100L, size2 = 100L, burn = 0.75, rate0 = 0.01, decay = 0.01, damping = 1e-03, rate1 = 0.95, rate2 = 0.99, parallel = FALSE, nthreads = 1L, verbose = TRUE, frequency = 250L, progress = FALSE) {
    .Call(`_sgdGMF_cpp_fit_coord_sgd`, Y, X, B, A, Z, U, V, O, W, familyname, linkname, varfname, ncomp, lambda, maxiter, eps, nafill, tol, size1, size2, burn, rate0, decay, damping, rate1, rate2, parallel, nthreads, verbose, frequency, progress)
}

#' @title Fit a GMF model using the adaptive SGD with block-wise minibatch subsampling
#'
#' @description Fit a GMF model using the adaptive SGD with block-wise minibatch subsampling
#'
#' @param Y matrix of responses (\eqn{n \times m})
#' @param X matrix of row fixed effects (\eqn{n \times p})
#' @param B initial row-effect matrix (\eqn{n \times p})
#' @param A initial column-effect matrix (\eqn{n \times q})
#' @param Z matrix of column fixed effects (\eqn{m \times q})
#' @param U initial factor matrix (\eqn{n \times d})
#' @param V initial loading matrix (\eqn{m \times d})
#' @param O matrix of constant offset (\eqn{n \times m})
#' @param W matrix of constant weights (\eqn{n \times m})
#' @param familyname a \code{glm} model family name
#' @param linkname a \code{glm} link function name
#' @param varfname variance function name
#' @param ncomp rank of the latent matrix factorization
#' @param lambda penalization parameters
#' @param maxiter maximum number of iterations
#' @param eps shrinkage factor for extreme predictions
#' @param nafill how often the missing values are updated
#' @param tol tolerance threshold for the stopping criterion
#' @param size1 row-minibatch dimension
#' @param size2 column-minibatch dimension
#' @param burn burn-in period in which the learning late is not decreased
#' @param rate0 initial learning rate
#' @param decay decay rate of the learning rate
#' @param damping diagonal dumping factor for the Hessian matrix
#' @param rate1 decay rate of the first moment estimate of the gradient
#' @param rate2 decay rate of the second moment estimate of the gradient
#' @param parallel if \code{TRUE}, allows for parallel computing
#' @param nthreads number of cores to be used in parallel
#' @param verbose if \code{TRUE}, print the optimization status
#' @param frequency how often the optimization status is printed
#' @param progress if \code{TRUE}, print an progress bar
#' 
#' @keywords internal
cpp.fit.block.sgd <- function(Y, X, B, A, Z, U, V, O, W, familyname, linkname, varfname, ncomp, lambda, maxiter = 1000L, eps = 0.01, nafill = 10L, tol = 1e-08, size1 = 100L, size2 = 100L, burn = 0.75, rate0 = 0.01, decay = 0.01, damping = 1e-03, rate1 = 0.95, rate2 = 0.99, parallel = FALSE, nthreads = 1L, verbose = TRUE, frequency = 250L, progress = FALSE) {
    .Call(`_sgdGMF_cpp_fit_block_sgd`, Y, X, B, A, Z, U, V, O, W, familyname, linkname, varfname, ncomp, lambda, maxiter, eps, nafill, tol, size1, size2, burn, rate0, decay, damping, rate1, rate2, parallel, nthreads, verbose, frequency, progress)
}

#' @title Fit a GMF model using the adaptive SGD with block-wise minibatch subsampling
#'
#' @description Fit a GMF model using the adaptive SGD with block-wise minibatch subsampling
#'
#' @param Y matrix of responses (\eqn{n \times m})
#' @param X matrix of row fixed effects (\eqn{n \times p})
#' @param B initial row-effect matrix (\eqn{n \times p})
#' @param A initial column-effect matrix (\eqn{n \times q})
#' @param Z matrix of column fixed effects (\eqn{m \times q})
#' @param U initial factor matrix (\eqn{n \times d})
#' @param V initial loading matrix (\eqn{m \times d})
#' @param O matrix of constant offset (\eqn{n \times m})
#' @param W matrix of constant weights (\eqn{n \times m})
#' @param familyname a \code{glm} model family name
#' @param linkname a \code{glm} link function name
#' @param varfname variance function name
#' @param ncomp rank of the latent matrix factorization
#' @param lambda penalization parameters
#' @param maxiter maximum number of iterations
#' @param eps shrinkage factor for extreme predictions
#' @param nafill how often the missing values are updated
#' @param tol tolerance threshold for the stopping criterion
#' @param size1 row-minibatch dimension
#' @param size2 column-minibatch dimension
#' @param burn burn-in period in which the learning late is not decreased
#' @param rate0 initial learning rate
#' @param decay decay rate of the learning rate
#' @param damping diagonal dumping factor for the Hessian matrix
#' @param rate1 decay rate of the first moment estimate of the gradient
#' @param rate2 decay rate of the second moment estimate of the gradient
#' @param parallel if \code{TRUE}, allows for parallel computing
#' @param nthreads number of cores to be used in parallel
#' @param verbose if \code{TRUE}, print the optimization status
#' @param frequency how often the optimization status is printed
#' @param progress if \code{TRUE}, print an progress bar
#' 
#' @keywords internal
cpp.fit.random.block.sgd <- function(Y, X, B, A, Z, U, V, O, W, familyname, linkname, varfname, ncomp, lambda, maxiter = 1000L, eps = 0.01, nafill = 10L, tol = 1e-08, size1 = 100L, size2 = 100L, burn = 0.75, rate0 = 0.01, decay = 0.01, damping = 1e-03, rate1 = 0.95, rate2 = 0.99, parallel = FALSE, nthreads = 1L, verbose = TRUE, frequency = 250L, progress = FALSE) {
    .Call(`_sgdGMF_cpp_fit_random_block_sgd`, Y, X, B, A, Z, U, V, O, W, familyname, linkname, varfname, ncomp, lambda, maxiter, eps, nafill, tol, size1, size2, burn, rate0, decay, damping, rate1, rate2, parallel, nthreads, verbose, frequency, progress)
}

