% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{cpp.fit.block.sgd}
\alias{cpp.fit.block.sgd}
\title{Fit a GMF model using the adaptive SGD with block-wise minibatch subsampling}
\usage{
cpp.fit.block.sgd(
  Y,
  X,
  B,
  A,
  Z,
  U,
  V,
  O,
  W,
  familyname,
  linkname,
  varfname,
  ncomp,
  lambda,
  maxiter = 1000L,
  eps = 0.01,
  nafill = 10L,
  tol = 1e-08,
  size1 = 100L,
  size2 = 100L,
  burn = 0.75,
  rate0 = 0.01,
  decay = 0.01,
  damping = 0.001,
  rate1 = 0.95,
  rate2 = 0.99,
  parallel = FALSE,
  nthreads = 1L,
  verbose = TRUE,
  frequency = 250L,
  progress = FALSE
)
}
\arguments{
\item{Y}{matrix of responses (\eqn{n \times m})}

\item{X}{matrix of row fixed effects (\eqn{n \times p})}

\item{B}{initial row-effect matrix (\eqn{n \times p})}

\item{A}{initial column-effect matrix (\eqn{n \times q})}

\item{Z}{matrix of column fixed effects (\eqn{m \times q})}

\item{U}{initial factor matrix (\eqn{n \times d})}

\item{V}{initial loading matrix (\eqn{m \times d})}

\item{O}{matrix of constant offset (\eqn{n \times m})}

\item{W}{matrix of constant weights (\eqn{n \times m})}

\item{familyname}{a \code{glm} model family name}

\item{linkname}{a \code{glm} link function name}

\item{varfname}{variance function name}

\item{ncomp}{rank of the latent matrix factorization}

\item{lambda}{penalization parameters}

\item{maxiter}{maximum number of iterations}

\item{eps}{shrinkage factor for extreme predictions}

\item{nafill}{how often the missing values are updated}

\item{tol}{tolerance threshold for the stopping criterion}

\item{size1}{row-minibatch dimension}

\item{size2}{column-minibatch dimension}

\item{burn}{burn-in period in which the learning late is not decreased}

\item{rate0}{initial learning rate}

\item{decay}{decay rate of the learning rate}

\item{damping}{diagonal dumping factor for the Hessian matrix}

\item{rate1}{decay rate of the first moment estimate of the gradient}

\item{rate2}{decay rate of the second moment estimate of the gradient}

\item{parallel}{if \code{TRUE}, allows for parallel computing}

\item{nthreads}{number of cores to be used in parallel}

\item{verbose}{if \code{TRUE}, print the optimization status}

\item{frequency}{how often the optimization status is printed}

\item{progress}{if \code{TRUE}, print an progress bar}
}
\description{
Fit a GMF model using the adaptive SGD with block-wise minibatch subsampling
}
\keyword{internal}
