% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/initGMF-class.R
\name{screeplot.initgmf}
\alias{screeplot.initgmf}
\title{Screeplot for the residuals of an initialized GMF model}
\usage{
\method{screeplot}{initgmf}(
  x,
  ...,
  ncomp = 20,
  type = c("deviance", "pearson", "working", "response", "link"),
  partial = FALSE,
  normalize = FALSE,
  cumulative = FALSE,
  proportion = FALSE
)
}
\arguments{
\item{x}{an object of class \code{sgdgmf}}

\item{...}{further arguments passed to or from other methods}

\item{ncomp}{number of components to be plotted}

\item{type}{the type of residuals which should be used}

\item{partial}{if \code{TRUE}, plots the eigenvalues of the partial residuals}

\item{normalize}{if \code{TRUE}, plots the eigenvalues of the standardized residuals}

\item{cumulative}{if \code{TRUE}, plots the cumulative sum of the eigenvalues}

\item{proportion}{if \code{TRUE}, plots the fractions of explained variance}
}
\value{
A ggplot object showing the residual screeplot of the model.
}
\description{
Plots the variances of the principal components of the residuals against the
number of principal component.
}
\examples{
\donttest{# Load the sgdGMF package
library(sgdGMF)

# Generate data from a Poisson model
data = sim.gmf.data(n = 100, m = 20, ncomp = 5, family = poisson())

# Fit a GMF model
init = sgdgmf.init(data$Y, ncomp = 3, family = poisson())

# Get the partial residual spectrum of a GMF model
screeplot(init) # screeplot of the var-cov matrix of the deviance residuals
screeplot(init, partial = TRUE) # screeplot of the partial residuals
screeplot(init, cumulative = TRUE) # cumulative screeplot
screeplot(init, proportion = TRUE) # proportion of explained residual variance
}
}
\seealso{
\code{\link{screeplot.sgdgmf}}.
}
