% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stochastic_growth_model.R
\name{summary_sgmod}
\alias{summary_sgmod}
\title{summary_sgmod}
\usage{
summary_sgmod(object, ...)
}
\arguments{
\item{object}{A \code{sgmodel} object.}

\item{...}{Additional arguments.}
}
\value{
It returns a list with the model parameters. It includes:
\item{Utility function }{The type of utility function. See the details of \code{util} for the available types}
\item{Capital share }{The exponent on capital in the Cobb-Douglas production function.}
\item{Discount factor }{The discount factor used in the model.}
\item{Depreciation }{The depreciation rate of capital used in the model.}
\item{Rho }{Autocorrelation of the TFP AR(1) process.}
\item{Sigma }{Standard deviation of the white noise in the TFP process.}
\item{Number of TFP states }{Number of states of the TFP process.}
}
\description{
The function \code{summary_sgmod} prints a summary for results of the \code{sgmodel} function.
}
\examples{
grid <- 200
utiltype <- "CRRA"
utilparam <- 4
A <- 1
depre <- 0.03
discount <- 0.95
prod <- 0.3
states <- 3
m <- 3
rho <- 0.2
sigma <- 0.02
model <- sgmodel(grid, utiltype, utilparam, A, depre, discount, prod, states, m, rho, sigma)
summary_sgmod(model)
}
