% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sgo_bng.R
\encoding{UTF-8}
\name{sgo_bng_lonlat}
\alias{sgo_bng_lonlat}
\title{British National Grid (BNG) Easting/Northing to Geodetic Coordinate
System (GCS)}
\usage{
sgo_bng_lonlat(x, to = 4258, OSTN = TRUE, OD = FALSE)
}
\arguments{
\item{x}{A \code{sgo_points} object with coordinates defined in the projected
coordinate system BNG (EPSGs 27700 or 7405)}

\item{to}{Numeric. Sets the \code{epsg} code of the destination Geodetic
Coordinate System. 4258 (ETRS89) by default.}

\item{OSTN}{Logical variable indicating whether use OSTN15 transformation
when TRUE or a less accurate but slightly faster single Helmert
transformation when FALSE.}

\item{OD}{Logical variable. When TRUE, and the output contains a
column with heights, then a new column is added to the result indicating the
ordnance datum (OD) used on each point. It is ignored when \code{OSTN=FALSE}.}
}
\value{
An object of class \code{sgo_points} whose coordinates are defined as
Longitude/Latitude.If \code{OD=TRUE} a column named \code{height.datum} is
added to the resulting object.
}
\description{
Converts Ordnance Survey grid reference easting/northing coordinates to GCS
longitude/latitude (SW corner of grid square).
}
\details{
The UK Ordnance Survey defined 'OSGB36' as the datum for the UK, based on the
'Airy 1830' ellipsoid. However, in 2014, they deprecated OSGB36 in favour of
ETRS89 for longitude/latitude coordinates. Thus, when converting to
longitude/latitude the OSGB36 datum should be always converted to ETRS89
(or WGS84).

According to the Transformations and OSGM15 User Guide, p. 8:
\emph{"...ETRS89 is a precise version of the better known WGS84 reference
system optimised for use in Europe; however, for most purposes it can be
considered equivalent to WGS84."} and \emph{"For all navigation, mapping,
GIS, and engineering applications within the tectonically stable parts of
Europe (including UK and Ireland), the term ETRS89 should be taken as
synonymous with WGS84."} This means that ETRS89 and WGS84 datums will be
considered equivalent by this routine.

If, for historical reasons, longitude/latitude coordinates must have the old
OSGB36 datum, then the parameter \code{to} must be set to 4277.

\strong{Note}: Grid references rounded to whole metres will give
latitude/logitude that are accurate to about 5 decimal places. In the UK,
0.00001 of a degree of latitude is about 70cm and 0.00001 of a degree of
longitude is about 1m.
All those coordinates outside the rectangle covered by OSTN15
will be automatically computed using the small Helmert transformation. Such
coordinates will be accurate up to about +/-5 metres.
Converting from BNG to lon/lat coordinates is slower than the other way
around, due to the iterative nature of the algorithm that is built into
OSTN15.
}
\examples{
p <- sgo_points(list(651409.903, 313177.270), epsg=27700)
p.84 <- sgo_bng_lonlat(p) #ETRS89 lon/lat
p.36 <- sgo_bng_lonlat(p, to=4277) #OSGB36 lon/lat
}
\references{
Ordnance Survey Limited, 2018. \emph{Transformations and OSGM15 user guide}
}
\seealso{
\code{\link{sgo_points}}, \code{\link{sgo_lonlat_bng}},
\code{\link{sgo_set_gcs}}, \code{\link{sgo_transform}}.
}
