% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils-samplerules.R
\name{rules}
\alias{rules}
\alias{strat_rule1}
\alias{strat_rule2}
\alias{ahels_nSamp}
\alias{ahels_threshold}
\title{Sampling rules}
\usage{
strat_rule1(n, s, i, strat_mask, add_strata, extraCols, mindist)

strat_rule2(n, s, add_strata, nCount, strata_m, extraCols, mindist)

ahels_nSamp(
  nSamp,
  nQuant,
  tolerance,
  nb,
  underRep,
  ratio,
  ratOrderUnder,
  matCovDens,
  matCovSampDens,
  samples,
  mats,
  vals
)

ahels_threshold(
  threshold,
  tolerance,
  nQuant,
  nb,
  ratio,
  underRep,
  ratOrderUnder,
  matCovDens,
  matCovSampDens,
  samples,
  mats,
  vals
)
}
\arguments{
\item{mindist}{Numeric. Minimum allowable distance between selected
samples. \code{Default = NULL}.}

\item{nSamp}{Numeric. Number of desired samples. \code{existing}, \code{include} and \code{force} influence this value.}

\item{nQuant}{Numeric. Number of quantiles to divide covariates and samples into. Quantiles that do not
cover at least 1 percent of the area of interest will be excluded and be returned as \code{NA}.}

\item{tolerance}{Numeric. Allowable tolerance (<= 0.1 (10%)) around quantile density of 1. If \code{nSamp} is used samples will be
added until the \code{1 - tolerance} density is reached. If \code{threshold} is used, samples will be added until the 
\code{threshold - tolerance} value is reached. This parameter allows the user to define a buffer around desired quantile densities
to permit the algorithm to not add additional samples if quantile density is very close to 1, or user-defined \code{threshold}.}

\item{threshold}{Numeric. Sample quantile ratio threshold. After the threshold \code{default = 0.9} is reached,
no additional samples will be added. Values close to 1 can cause the algorithm to continually loop.}
}
\value{
Allocated samples to be returned by \code{sample_strat()} & \code{sample_ahels()}.
}
\description{
Sampling rules

Stratified rule 1

Stratified rule 2

AHELS nSamp

AHELS threshold
}
\concept{rules}
\keyword{internal}
