% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/strat_kmeans.R
\name{strat_kmeans}
\alias{strat_kmeans}
\title{k-means stratification}
\usage{
strat_kmeans(
  mraster,
  nStrata,
  iter = 500,
  algorithm = "Lloyd",
  center = TRUE,
  scale = TRUE,
  plot = FALSE,
  details = FALSE,
  filename = NULL,
  overwrite = FALSE,
  ...
)
}
\arguments{
\item{mraster}{spatRaster. ALS metrics raster.}

\item{nStrata}{Numeric. Number of desired strata.}

\item{iter}{Numeric. The maximum number of iterations allowed.}

\item{algorithm}{Character. \code{"Lloyd"} (default) or
\code{"MacQueen"} algorithms.}

\item{center}{Logical. Value indicating whether the variables should be shifted to be zero centered.}

\item{scale}{Logical. Value indicating whether the variables should be scaled to have unit variance.}

\item{plot}{Logical. Plots output strata raster and visualized
strata with boundary dividers.}

\item{details}{Logical. If \code{FALSE} (default) output is only
stratification raster. If \code{TRUE} return a list where \code{$details} is additional 
stratification information and \code{$raster} is the output stratification spatRaster.}

\item{filename}{Character. Path to write stratified raster to disc.}

\item{overwrite}{Logical. Specify whether \code{filename} should be overwritten on disc.}

\item{...}{Additional arguments to be passed to \code{\link[stats]{kmeans}} function.}
}
\value{
output stratification \code{spatRaster}, or a list when \code{details = TRUE}.
}
\description{
Stratify metrics raster using \code{\link[stats]{kmeans}} algorithm
}
\examples{
#--- Load raster and access files ---#
r <- system.file("extdata", "mraster.tif", package = "sgsR")
mr <- terra::rast(r)

#--- perform stratification using k-means ---#
kmeans <- strat_kmeans(
  mraster = mr,
  nStrata = 5
)

kmeans <- strat_kmeans(
  mraster = mr,
  nStrata = 5,
  iter = 1000,
  algorithm = "MacQueen",
  details = TRUE
)

}
\seealso{
Other stratify functions: 
\code{\link{strat_breaks}()},
\code{\link{strat_map}()},
\code{\link{strat_poly}()},
\code{\link{strat_quantiles}()}
}
\author{
Tristan R.H. Goodbody
}
\concept{stratify functions}
