% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sample_existing.R
\name{sample_existing}
\alias{sample_existing}
\title{Sample existing}
\usage{
sample_existing(
  existing,
  nSamp,
  raster = NULL,
  cost = NULL,
  access = NULL,
  buff_inner = NULL,
  buff_outer = NULL,
  iter = 10000,
  plot = FALSE,
  details = FALSE,
  filename = NULL,
  overwrite = FALSE,
  ...
)
}
\arguments{
\item{existing}{sf 'POINT'.  Existing plot network.}

\item{nSamp}{Numeric. Number of desired samples.}

\item{raster}{spatRaster. Raster used to define population distributions.}

\item{cost}{Numeric/Character. Index or name of covariate within \code{mraster} to be used to constrain cLHS sampling.
If default (\code{NULL}), a cost constraint is not used.}

\item{access}{sf. Road access network - must be lines.}

\item{buff_inner}{Numeric. Inner buffer boundary specifying distance
from access where plots cannot be sampled.}

\item{buff_outer}{Numeric. Outer buffer boundary specifying distance
from access where plots can be sampled.}

\item{iter}{Numeric. Value giving the number of iterations within the Metropolis-Hastings process.}

\item{plot}{Logical. Plots output strata raster with samples.}

\item{details}{Logical. If \code{FALSE} (default) output is sf object of
systematic samples. If \code{TRUE} returns a list of sf objects where \code{tessellation}
is the tessellation grid for sampling, and \code{samples} are the systematic samples.}

\item{filename}{Character. Path to write output samples.}

\item{overwrite}{Logical. Choice to overwrite existing \code{filename} if it exists.}

\item{...}{Additional arguments for clhs sampling. See \code{\link[clhs]{clhs}}.}
}
\value{
An sf object of samples or a list object if `details = TRUE`
}
\description{
Sub-sample an existing sample using \code{\link[clhs]{clhs}} functionality.
}
\note{
If providing only \code{existing} - all attributes will be used for sampling. Remove attributes not indented for sampling
prior to using this algorithm.
}
\examples{
#--- Load raster ---#
r <- system.file("extdata", "mraster.tif", package = "sgsR")
mr <- terra::rast(r)

#--- generate an existing sample ---#
e <- sample_systematic(raster = mr, cellsize = 200)

#--- perform sub-sampling ---#
sample_existing(
  existing = e,
  raster = mr,
  nSamp = 50
)

}
\seealso{
Other sample functions: 
\code{\link{sample_ahels}()},
\code{\link{sample_balanced}()},
\code{\link{sample_clhs}()},
\code{\link{sample_nc}()},
\code{\link{sample_srs}()},
\code{\link{sample_strat}()},
\code{\link{sample_sys_strat}()},
\code{\link{sample_systematic}()}
}
\author{
Tristan R.H. Goodbody
}
\concept{sample functions}
