% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calculate_pop.R
\name{calculate_pop}
\alias{calculate_pop}
\title{Population descriptors}
\usage{
calculate_pop(mraster, PCA = FALSE, matQ = TRUE, nQuant = 10, matCov = TRUE)
}
\arguments{
\item{mraster}{spatRaster. ALS metrics raster.}

\item{PCA}{Logical. Calculates principal component loadings of the population for PCA similarity factor testing.
\code{default = FALSE}.}

\item{matQ}{Logical. Calculates quantile matrix of the population for quantile comparison testing.
\code{default = TRUE}.}

\item{nQuant}{Numeric. Number of quantiles to divide the population into for \code{matQ}.
\code{default = 10}.}

\item{matCov}{Logical. Calculates covariate matrix of the population. Needed for Kullback–Leibler divergence testing.
\code{default = TRUE}. Requires \code{matQ = TRUE}.}
}
\value{
List of matrices to be used as input for \code{\link{calculate_lhsOpt}}.
}
\description{
Population matrices and descriptions of metric raster data

Calculates population level statistics including principal components, quantile matrix, and covariance matrix
needed necessary for \code{\link{calculate_lhsOpt}}. Outputs can also be used as an input for \code{\link{sample_ahels}}.
}
\note{
Special thanks to Dr. Brendan Malone for the original implementation of this algorithm.
}
\examples{
#--- Load raster and access files ---#
r <- system.file("extdata", "mraster.tif", package = "sgsR")
mr <- terra::rast(r)

calculate_pop(mraster = mr)

}
\references{
Malone BP, Minansy B, Brungard C. 2019. Some methods to improve the utility of conditioned Latin hypercube sampling. PeerJ 7:e6451 DOI 10.7717/peerj.6451
}
\seealso{
Other calculate functions: 
\code{\link{calculate_allocation_existing}()},
\code{\link{calculate_allocation}()},
\code{\link{calculate_coobs}()},
\code{\link{calculate_distance}()},
\code{\link{calculate_pcomp}()},
\code{\link{calculate_representation}()},
\code{\link{calculate_sampsize}()}
}
\author{
Tristan R.H. Goodbody
}
\concept{calculate functions}
