% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/strat_breaks.R
\name{strat_breaks}
\alias{strat_breaks}
\title{Breaks stratification}
\usage{
strat_breaks(
  mraster,
  breaks,
  map = FALSE,
  plot = FALSE,
  details = FALSE,
  filename = NULL,
  overwrite = FALSE
)
}
\arguments{
\item{mraster}{Spatraster. Raster to stratify. Layers in \code{mraster} must match the number of
\code{breaks} vectors provided.}

\item{breaks}{Numeric. Vector of breakpoints for each layer of \code{mraster}. If \code{mraster} has multiple layers,
\code{breaks} must be a list with an equal number of objects.}

\item{map}{Logical. Map individual stratified layers to a combined stratification. Will output a multi-layer
\code{SpatRaster} with individual stratifications for each \code{mraster} layer and an additional mapped stratification
 named \code{"strata"}.}

\item{plot}{Logical. Plots output strata raster and visualized
strata with boundary dividers.}

\item{details}{Logical. If \code{FALSE} (default) output is only
stratification raster. If \code{TRUE} return a list where \code{$details} is additional
stratification information and \code{$raster} is the output stratification spatRaster.}

\item{filename}{Character. Path to write stratified raster to disc.}

\item{overwrite}{Logical. Specify whether \code{filename} should be overwritten on disc.}
}
\value{
Returns an output stratification \code{spatRaster} or a list when \code{details = TRUE}.

When a list is returned:
\enumerate{
\item \code{raster} is a stratified \code{spatRaster} based on quantiles. If \code{stack = TRUE} will
be the number of layers of \code{mraster} plus the final output
\item \code{breaks} is a list output of \code{breaks}
\item \code{plot} is a \code{ggplot} histogram object showing distribution(s) and break point(s).
}
}
\description{
Stratify metrics raster using user defined breaks
}
\examples{
#--- Load raster ---#
r <- system.file("extdata", "mraster.tif", package = "sgsR")
mr <- terra::rast(r)

#--- create vector breaks ---#
br.zq90 <- c(3, 5, 11, 18)
br.pz2 <- c(20, 40, 60, 80)

strat_breaks(
  mraster = mr$zq90,
  breaks = br.zq90
)


strat_breaks(
  mraster = mr[[1:2]],
  breaks = list(br.zq90, br.pz2),
  details = TRUE
)
}
\seealso{
Other stratify functions: 
\code{\link{strat_kmeans}()},
\code{\link{strat_map}()},
\code{\link{strat_poly}()},
\code{\link{strat_quantiles}()}
}
\author{
Tristan R.H. Goodbody
}
\concept{stratify functions}
