% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/coefDirect.R
\name{coefDirect}
\alias{coefDirect}
\title{Coefficient of Direct Normal Irradiance reduction}
\usage{
coefDirect(type, facade_az, solar_pos)
}
\arguments{
\item{type}{\code{character}, specifying surface type. All values must be either \code{"roof"} or \code{"facade"}}

\item{facade_az}{Facade azimuth, in decimal degrees from North. Only relevant for \code{type="facade"}}

\item{solar_pos}{A matrix with two columns representing sun position(s); first column is the solar azimuth (in decimal degrees from North), second column is sun elevation (in decimal degrees); rows represent different positions (e.g. at different times of day)}
}
\value{
Numeric vector of coefficients, to be multiplied by the direct beam radiation values. The vector length is the same as the length of the longest input (see \strong{Note} below)
}
\description{
This function calculates the coefficient of reduction in Direct Normal Irradiance load due to angle of incidence. For example, a coefficient of 1 is obtained when the sun is perpendicular to the surface.
}
\note{
All four arguments are recycled to match each other's length. For example, you may specify a single \code{type} value of \code{"roof"} or \code{"facade"} and a single \code{facade_az} value, but multiple \code{sun_az} and \code{sun_elev} values, for calculating the coefficients for a single location given different positions of the sun, etc.
}
\examples{
# Basic usage
coefDirect(type = "facade", facade_az = 180, solar_pos = matrix(c(210, 30), ncol = 2))

# Demonstration - Direct beam radiation coefficient on 'facades'
sun_az = seq(270, 90, by = -5)
sun_elev = seq(0, 90, by = 5)
solar_pos = expand.grid(sun_az = sun_az, sun_elev = sun_elev)
solar_pos$coef = coefDirect(type = "facade", facade_az = 180, solar_pos = as.matrix(solar_pos))[1, ]
coef = reshape2::acast(solar_pos, sun_az ~ sun_elev, value.var = "coef")
image(
  180 - sun_az, sun_elev, coef,
  col = rev(heat.colors(10)),
  breaks = seq(0, 1, 0.1),
  asp = 1,
  xlab = "Facade azimuth - Sun azimuth (deg)",
  ylab = "Sun elevation (deg)",
  main = "Facade - Coefficient of Direct Normal Irradiance"
)
contour(180 - sun_az, sun_elev, coef, add = TRUE)

# Demonstration - Direct beam radiation coefficient on 'roofs'
solar_pos$coef = coefDirect(type = "roof", facade_az = 180, solar_pos = as.matrix(solar_pos))[1, ]
coef = reshape2::acast(solar_pos, sun_az ~ sun_elev, value.var = "coef")
image(
  180 - sun_az, sun_elev, coef,
  col = rev(heat.colors(10)),
  breaks = seq(0, 1, 0.1),
  asp = 1,
  xlab = "Facade azimuth - Sun azimuth (deg)",
  ylab = "Sun elevation (deg)",
  main = "Roof - Coefficient of Direct Normal Irradiance"
)
contour(180 - sun_az, sun_elev, coef, add = TRUE)
}
