% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/default.mass.R
\name{default.mass}
\alias{default.mass}
\alias{print.shallot.default.mass}
\title{Default Mass Selection}
\usage{
default.mass(
  mass,
  list.epam,
  dis,
  new.draws = TRUE,
  w = c(1, 1, 1),
  discount = 0,
  temp = 10,
  loss = "binder",
  n.draws = 100L,
  two.stage = TRUE,
  parallel = TRUE
)

\method{print}{shallot.default.mass}(x, ...)
}
\arguments{
\item{mass}{optional, a vector of mass values.}

\item{list.epam}{optional, a list of expected pairwise allocation matrices.
Each matrix in the list needs the attributes "\code{mass}" and
"\code{n.draws}".}

\item{dis}{a dissimilarity structure of class \code{dist}.}

\item{new.draws}{logical; if \code{TRUE} then new draws are obtained at each
mass value.}

\item{w}{a vector of length 3 of the weights to be used in the
\code{\link{mass.algorithm}}.}

\item{discount}{parameter of the Ewens-Pitman Attraction distribution.}

\item{temp}{temperature parameter of the Ewens-Pitman Attraction
distribution.}

\item{loss}{One of \code{"binder"} or \code{"VI.lb"} to indicate
the optimization should seek to minimize the expectation of the
Binder loss (Binder 1978) or the lower bound of the expectation of the variation of
information loss (Wade & Ghahramani 2017), respectively.}

\item{n.draws}{number of draws of partitions to be obtained at each mass
value.}

\item{two.stage}{logical; if \code{TRUE}, the two stage algorithm is
implemented in \code{\link{mass.algorithm}}.}

\item{parallel}{logical; if \code{TRUE} computations will take advantage
multiple CPU cores.}

\item{x}{An object from the \code{\link{default.mass}} function.}

\item{...}{currently ignored}
}
\value{
An object of class \code{shallot.default.mass}. This object is a list
  containing a matrix of `best' possible mass values to maximize partition
  confidence and minimize the variance ratio, the clustering estimate, the
  expected pairwise allocation matrix, parameters used for optimization and
  the EPA distribution, and the list of expected pairwise allocation matrices
  for each mass value.
}
\description{
This function selects an optimal mass value for Cluster Analysis via Random
Partition Distribtuions, using the Ewens-Pitman Attraction distribution.
}
\details{
The function draws \code{n.draws} partitions at each specified mass value. If
a vector of mass values is not given, then the default of
\code{seq(0.1,10,0.2)} is used for loss
\code{"VI.lb"} and \code{seq(0.1,5,0.05)} used for
the other loss functions.

If a list of expected pairwise allocation matrices (EPAM) is provided,
additional draws at matching mass values are added to the corresponding
matrix. Additionally, no new draws are needed for estimation, if a list of
EPAMs is provided.

A partition/clustering estimate from each EPAM is obtained using the SALSO
method in \code{\link[salso]{salso}}. The estimate given minimizes the
specified \code{loss} function with respect to the EPAM.

The function then uses the \code{\link{mass.algorithm}} to select the optimal
mass value for clustering estimation.
}
\seealso{
Other Default Mass Selection: 
\code{\link{mass.algorithm}()},
\code{\link{partition.confidence}()},
\code{\link{variance.ratio}()}
}
\concept{Default Mass Selection}
