% Generated by roxygen2 (4.1.0): do not edit by hand
% Please edit documentation in R/shapeR.R
\name{plotWavelet}
\alias{plotWavelet}
\title{Mean and standard deviation of the wavelet coefficients}
\usage{
plotWavelet(object, level, start.angle = 0, class.name=NULL,useStdcoef=FALSE,...)
}
\arguments{
\item{object}{A \code{\linkS4class{shapeR}} object}

\item{level}{The wavelet level to be shown}

\item{start.angle}{The angle in degrees, the x-axis should start on}

\item{class.name}{Column name in master list for partitioning the data into groups and showing the ratio of variation among groups.}

\item{useStdcoef}{Choose "TRUE" or "FALSE" if coefficients should be standardized or not}

\item{...}{Additional parameters to be passed to 'plot'}
}
\description{
The mean and standard deviation of the wavelet coefficients
}
\examples{
data(otoliths)
shape = stdCoefs(shape,classes="pop","length_cm")
plotWavelet(shape,level=5,class.name= "pop",useStdcoef=TRUE)
}
\author{
Lisa Anne Libungan
}

