% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shapviz.R
\name{shapviz}
\alias{shapviz}
\alias{shapviz.default}
\alias{shapviz.matrix}
\alias{shapviz.xgb.Booster}
\alias{shapviz.lgb.Booster}
\alias{shapviz.explain}
\alias{shapviz.treeshap}
\title{Initialize "shapviz" Object}
\usage{
shapviz(object, ...)

\method{shapviz}{default}(object, ...)

\method{shapviz}{matrix}(object, X, baseline = 0, ...)

\method{shapviz}{xgb.Booster}(object, X_pred, X = X_pred, which_class = NULL, ...)

\method{shapviz}{lgb.Booster}(object, X_pred, X = X_pred, which_class = NULL, ...)

\method{shapviz}{explain}(object, X, baseline = 0, ...)

\method{shapviz}{treeshap}(object, X = object[["observations"]], baseline = 0, ...)
}
\arguments{
\item{object}{Object to be converted to an object of type "shapviz".}

\item{...}{Parameters passed to other methods (currently only used by
the \code{predict} functions of XGBoost and LightGBM).}

\item{X}{Corresponding matrix or data.frame of feature values used for visualization.}

\item{baseline}{Optional baseline value, representing the average response at the
scale of the SHAP values. It will be used for plot methods that explain single
predictions.}

\item{X_pred}{Feature matrix as expected by the \code{predict} function of
XGBoost/LightGBM. In case \code{object} is an XGBoost model, it can also be
an \code{xgb.DMatrix}.}

\item{which_class}{In case of a multiclass setting, which class
to explain (an integer between 1 and the \code{num_class} parameter of the model).}
}
\value{
An object of class "shapviz" with the following three elements:
\itemize{
\item \code{S}: A numeric \code{matrix} of SHAP values.
\item \code{X}: A \code{data.frame} containing the feature values corresponding to \code{S}.
\item \code{baseline}: Baseline value, representing the average prediction at the scale of the SHAP values.
}
}
\description{
This function creates an object of class "shapviz" from one of the following inputs:
\itemize{
\item A matrix of SHAP values.
\item A fitted XGBoost model.
\item A fitted LightGBM model.
\item An "explain" object from the package "fastshap".
\item The result of calling \code{treeshap()} from the "treeshap" package.
}
Along with the main input, a dataset \code{X} of feature values is required that
is used for visualization only.
It can thus contain character or factor variables even if
the SHAP values were calculated from a purely numeric feature matrix.
}
\section{Methods (by class)}{
\itemize{
\item \code{default}: Default method to initialize a "shapviz" object.

\item \code{matrix}: Creates a "shapviz" object from a matrix of SHAP values.

\item \code{xgb.Booster}: Creates a "shapviz" object from an XGBoost model.

\item \code{lgb.Booster}: Creates a "shapviz" object from a LightGBM model.

\item \code{explain}: Creates a "shapviz" object from fastshap's "explain()" method.

\item \code{treeshap}: Creates a "shapviz" object from treeshap's "treeshap()" method.
}}

\examples{
S <- matrix(c(1, -1, -1, 1), ncol = 2, dimnames = list(NULL, c("x", "y")))
X <- data.frame(x = c("a", "b"), y = c(100, 10))
shapviz(S, X, baseline = 4)

X_pred <- data.matrix(iris[, -1])
dtrain <- xgboost::xgb.DMatrix(X_pred, label = iris[, 1])
fit <- xgboost::xgb.train(data = dtrain, nrounds = 50)

# Will use numeric matrix "X_pred" as feature matrix
shapviz(fit, X_pred = X_pred)

# Will use original values as feature matrix
x <- shapviz(fit, X_pred = X_pred, X = iris[, -1])
x

# "X_pred" can also be passed as xgb.DMatrix, but only if X is passed as well!
shapviz(fit, X_pred = dtrain, X = iris[, -1])

# In multiclass setting, we need to specify which_class (integer starting at 1)
# should be explained.
params <- list(objective="multi:softprob", num_class = 3)
X_pred <- data.matrix(iris[, -5])
dtrain <- xgboost::xgb.DMatrix(X_pred, label = as.integer(iris[, 5]) - 1L)
fit <- xgboost::xgb.train(params = params, data = dtrain, nrounds = 50)
x <- shapviz(fit, X_pred = X_pred, which_class = 3)
x
}
