% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/shapviz_methods.R
\name{collapse_shap}
\alias{collapse_shap}
\alias{collapse_shap.default}
\alias{collapse_shap.matrix}
\title{Collapse SHAP values}
\usage{
collapse_shap(object, ...)

\method{collapse_shap}{default}(object, ...)

\method{collapse_shap}{matrix}(object, collapse = NULL, ...)
}
\arguments{
\item{object}{An object containing SHAP values.}

\item{...}{Currently unused.}

\item{collapse}{A named list of character vectors. Each vector specifies a group of
column names in the SHAP matrix that should be collapsed to a single column by summation.
The name of the new column equals the name of the vector in \code{collapse}.}
}
\value{
A matrix with collapsed columns.
}
\description{
Function used to collapse groups of columns in the SHAP matrix by rowwise summation.
A typical application is when the matrix of SHAP values is generated by a model with
one or multiple one-hot encoded variables and the explanations should be done using
the original variables.
}
\section{Methods (by class)}{
\itemize{
\item \code{default}: Default method.

\item \code{matrix}: Collapse method for object of class "matrix".
}}

\examples{
S <- cbind(
  x = c(0.1, 0.1, 0.1),
  `age low` = c(0.2, -0.1, 0.1),
  `age mid` = c(0, 0.2, -0.2),
  `age high` = c(1, -1, 0)
)
collapse <- list(age = c("age low", "age mid", "age high"))
collapse_shap(S, collapse)
}
\seealso{
\code{\link{shapviz}}.
}
