% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reconstruct_pattern_multi.R
\name{reconstruct_pattern_multi}
\alias{reconstruct_pattern_multi}
\title{reconstruct_pattern_multi}
\usage{
reconstruct_pattern_multi(
  marked_pattern,
  xr = marked_pattern$window$xrange,
  yr = marked_pattern$window$yrange,
  n_repetitions = 1,
  max_steps = 10000,
  no_change = 5,
  rcount = 250,
  rmax = 25,
  issue = 1000,
  divisor = "r",
  kernel_arg = "epanechnikov",
  timing = FALSE,
  energy_evaluation = FALSE,
  plot = FALSE,
  Lp = 1,
  bw = if (divisor \%in\% c("r", "d")) 0.5 else 5,
  sd = "step",
  steps_tol = 1000,
  tol = 1e-04,
  w_markcorr = c(d_d = 1, all = 1, d_all = 1, all_all = 1, d_d0 = 1, all0 = 1, d_all0 =
    1, all_all0 = 1),
  prob_of_actions = c(move_coordinate = 0.4, switch_coords = 0.1, exchange_mark_one =
    0.1, exchange_mark_two = 0.1, pick_mark_one = 0.2, pick_mark_two = 0.1),
  k = 1,
  w_statistics = c(),
  verbose = TRUE
)
}
\arguments{
\item{marked_pattern}{ppp  object with marked pattern. See Details section
for more information.}

\item{xr, yr}{Maximum extent in x and y direction of observation window.}

\item{n_repetitions}{Integer representing the number of simulations to be
performed.}

\item{max_steps}{Maximum number simulation steps.}

\item{no_change}{Integer representing the number of iterations
(per 1000 simulation steps) after which the reconstruction is terminated if the
energy does not decrease.}

\item{rcount}{Integer representing the number of intervals for which the
summary statistics are evaluated.}

\item{rmax}{Maximum distance [m] up to which the summary statistics are
evaluated.}

\item{issue}{Integer that determines after how many simulations steps an
output occurs.}

\item{divisor}{Choice of divisor in the estimation formula: either "r" or "d".}

\item{kernel_arg}{The kernel used to calculate the energy, possible kernels
can be: Gaussian, Epanechnikov, Rectangular, Cumulative.}

\item{timing}{Logical value: The computation time is measured if this is TRUE.}

\item{energy_evaluation}{Logical value: If this is TRUE, the procedure stores
the energy shares of the total energy per simulation step.}

\item{plot}{Logical value: If this is TRUE, the procedure records the
point pattern during optimization and updated.}

\item{Lp}{Distance measure for the calculation of the energy function
(Lp distance, 1 <= p < Inf).}

\item{bw}{Bandwidth [m] with which the kernels are scaled, so that this is
the standard deviation of the smoothing kernel.}

\item{sd}{This is the standard deviation [m] used in the move_coordinate action.}

\item{steps_tol}{After the value steps_tol it is checked whether the energy
change is smaller than tol.}

\item{tol}{Stops the procedure of energy if more than 1 - tol times no changes.}

\item{w_markcorr}{Vector of possible weightings of individual mcf's. (Default: all equal).}

\item{prob_of_actions}{Vector of probabilities for the actions performed.
\code{c(move_coordinate = 0.4, switch_coords = 0.1, exchange_mark_one = 0.1,
exchange_mark_two = 0.1, pick_mark_one = 0.2, pick_mark_two = 0.1)}.}

\item{k}{Vector of values k; used only if Dk is included in w_statistics.}

\item{w_statistics}{vector of named weights for optional spatial statistics
from the \code{spatstat} package to be included in the energy calculation. This may
include Dk, K, Hs, pcf.}

\item{verbose}{Logical if progress report is printed.}
}
\value{
rd_multi
}
\description{
Pattern reconstruction of a pattern marked by multiple traits.
}
\details{
A novel approach carries out a pattern reconstruction of marked dot patterns
as described by Tscheschel and Stoyan (2006) and Wiegand and Moloney (2014).

One particular feature is the simultaneous consideration of both marks,
accounting for their correlation during reconstruction.

The marked point pattern (PPP object) must is currently structured as follows:
X-coordinate, Y-coordinate, metric mark (e.g. diameter at breast height),
and nominal mark (e.g. tree species).It is calculated in the unit metre [m].

A combination of the mark correlation function and pair correlation function
is used for pattern description. Additional summary statistics may be
considered.Two randomly selected marks are chosen in each iteration, and one
of various actions is performed. Changes will only be retained if the
difference between the observed and reconstructed pattern decreases
(minimizing energy).

This method is currently only suitable for homogeneous point patterns.

A comprehensive description of the method can be found in Wudel et al. (2023).
}
\examples{
\dontrun{

# Random example data set
xr <- 500
yr <- 1000
N <- 400
y <- runif(N, min = 0, max = yr)
x <- runif(N, min = 0, max = xr)

species <- sample(c("A","B"), N, replace = TRUE)
diameter <- runif(N, 0.1, 0.4)

random <- data.frame(x = x, y = y, dbh = diameter, species = factor(species))

marked_pattern <- spatstat.geom::as.ppp(random, W = spatstat.geom::owin(c(0, xr), c(0, yr)))

# Reconstruction function
reconstruction <- reconstruct_pattern_multi(marked_pattern, n_repetitions = 2,
max_steps = 10000)
}

}
\references{
Kirkpatrick, S., Gelatt, C.D.Jr., Vecchi, M.P., 1983. Optimization by simulated
annealing. Science 220, 671–680. <https://doi.org/10.1126/science.220.4598.671>

Tscheschel, A., Stoyan, D., 2006. Statistical reconstruction of random point
patterns. Computational Statistics and Data Analysis 51, 859–871.
<https://doi.org/10.1016/j.csda.2005.09.007>

Wiegand, T., Moloney, K.A., 2014. Handbook of spatial point-pattern analysis in
ecology. Chapman and Hall/CRC Press, Boca Raton. ISBN 978-1-4200-8254-8

Wudel, C., Schlicht, R., & Berger, U. (2023). Multi-trait point pattern
reconstruction of plant ecosystems. Methods in Ecology and Evolution, 14, 2668–2679.
https://doi.org/10.1111/2041-210X.14206
}
\seealso{
\code{\link{fit_point_process}} \cr
\code{\link{reconstruct_pattern}} \cr
\code{\link{reconstruct_pattern_marks}}
}
