% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calibration.R
\name{CalibrationPlot}
\alias{CalibrationPlot}
\title{Calibration plot}
\usage{
CalibrationPlot(
  stability,
  block_id = NULL,
  col = NULL,
  pch = 19,
  cex = 0.7,
  xlim = NULL,
  ylim = NULL,
  bty = "o",
  lines = TRUE,
  lty = 3,
  lwd = 2,
  show_argmax = TRUE,
  show_pix = FALSE,
  show_piy = FALSE,
  offset = 0.3,
  legend = TRUE,
  legend_length = NULL,
  legend_range = NULL,
  ncol = 1,
  xlab = NULL,
  ylab = NULL,
  zlab = expression(italic(q)),
  xlas = 2,
  ylas = NULL,
  zlas = 2,
  cex.lab = 1.5,
  cex.axis = 1,
  cex.legend = 1.2,
  xgrid = FALSE,
  ygrid = FALSE,
  params = c("ny", "alphay", "nx", "alphax")
)
}
\arguments{
\item{stability}{output of \code{\link{VariableSelection}},
\code{\link{GraphicalModel}} or \code{\link{BiSelection}}.}

\item{block_id}{ID of the block to visualise. Only used for multi-block
stability selection graphical models. If \code{block_id=NULL}, all blocks
are represented in separate panels.}

\item{col}{vector of colours.}

\item{pch}{type of point, as in \code{\link[graphics]{points}}.}

\item{cex}{size of point.}

\item{xlim}{displayed range along the x-axis. Only used if \code{stability}
is the output of \code{\link{BiSelection}}.}

\item{ylim}{displayed range along the y-axis. Only used if \code{stability}
is the output of \code{\link{BiSelection}}.}

\item{bty}{character string indicating if the box around the plot should be
drawn. Possible values include: \code{"o"} (default, the box is drawn), or
\code{"n"} (no box).}

\item{lines}{logical indicating if the points should be linked by lines. Only
used if \code{stability} is the output of \code{\link{BiSelection}} or
\code{\link{Clustering}}.}

\item{lty}{line type, as in \code{\link[graphics]{par}}. Only used if
\code{stability} is the output of \code{\link{BiSelection}}.}

\item{lwd}{line width, as in \code{\link[graphics]{par}}. Only used if
\code{stability} is the output of \code{\link{BiSelection}}.}

\item{show_argmax}{logical indicating if the calibrated parameter(s) should
be indicated by lines.}

\item{show_pix}{logical indicating if the calibrated threshold in selection
proportion in \code{X} should be written for each point. Only used if
\code{stability} is the output of \code{\link{BiSelection}}.}

\item{show_piy}{logical indicating if the calibrated threshold in selection
proportion in \code{Y} should be written for each point. Only used if
\code{stability} is the output of \code{\link{BiSelection}} with
penalisation of the outcomes.}

\item{offset}{distance between the point and the text, as in
\code{\link[graphics]{text}}. Only used if \code{show_pix=TRUE} or
\code{show_piy=TRUE}.}

\item{legend}{logical indicating if the legend should be included.}

\item{legend_length}{length of the colour bar. Only used if \code{stability}
is the output of \code{\link{VariableSelection}} or
\code{\link{GraphicalModel}}.}

\item{legend_range}{range of the colour bar. Only used if \code{stability} is
the output of \code{\link{VariableSelection}} or
\code{\link{GraphicalModel}}.}

\item{ncol}{integer indicating the number of columns in the legend.}

\item{xlab}{label of the x-axis.}

\item{ylab}{label of the y-axis.}

\item{zlab}{label of the z-axis. Only used if \code{stability} is the output
of \code{\link{VariableSelection}} or \code{\link{GraphicalModel}}.}

\item{xlas}{orientation of labels on the x-axis, as \code{las} in
\code{\link[graphics]{par}}.}

\item{ylas}{orientation of labels on the y-axis, as \code{las} in
\code{\link[graphics]{par}}.}

\item{zlas}{orientation of labels on the z-axis, as \code{las} in
\code{\link[graphics]{par}}.}

\item{cex.lab}{font size for labels.}

\item{cex.axis}{font size for axes.}

\item{cex.legend}{font size for text legend entries.}

\item{xgrid}{logical indicating if a vertical grid should be drawn. Only used
if \code{stability} is the output of \code{\link{BiSelection}}.}

\item{ygrid}{logical indicating if a horizontal grid should be drawn. Only
used if \code{stability} is the output of \code{\link{BiSelection}}.}

\item{params}{vector of possible parameters if \code{stability} is of class
\code{bi_selection}. The order of these parameters defines the order in
which they are represented. Only used if \code{stability} is the output of
\code{\link{BiSelection}}.}
}
\value{
A calibration plot.
}
\description{
Creates a plot showing the stability score as a function of the parameter(s)
controlling the level of sparsity in the underlying feature selection
algorithm and/or the threshold in selection proportions. See examples in
\code{\link{VariableSelection}}, \code{\link{GraphicalModel}},
\code{\link{Clustering}} and \code{\link{BiSelection}}.
}
\seealso{
\code{\link{VariableSelection}}, \code{\link{GraphicalModel}},
  \code{\link{Clustering}}, \code{\link{BiSelection}}
}
