% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calibration.R
\name{WeightBoxplot}
\alias{WeightBoxplot}
\title{Stable attribute weights}
\usage{
WeightBoxplot(
  stability,
  at = NULL,
  argmax_id = NULL,
  col = NULL,
  boxwex = 0.3,
  xlab = "",
  ylab = "Weight",
  cex.lab = 1.5,
  las = 3,
  frame = "F",
  add = FALSE,
  ...
)
}
\arguments{
\item{stability}{output of \code{\link{Clustering}}.}

\item{at}{coordinates along the x-axis (more details in
\code{\link[graphics]{boxplot}}).}

\item{argmax_id}{optional indices of hyper-parameters. If
\code{argmax_id=NULL}, the calibrated hyper-parameters are used.}

\item{col}{optional vector of colours.}

\item{boxwex}{box width (more details in \code{\link[graphics]{boxplot}}).}

\item{xlab}{label of the x-axis.}

\item{ylab}{label of the y-axis.}

\item{cex.lab}{font size for labels.}

\item{las}{orientation of labels on the x-axis (see
\code{\link[graphics]{par}}).}

\item{frame}{logical indicating if the box around the plot should be drawn
(more details in \code{\link[graphics]{boxplot}}).}

\item{add}{logical indicating if the boxplot should be added to the current
plot.}

\item{...}{additional parameters passed to \code{\link[graphics]{boxplot}}).}
}
\value{
A boxplot.
}
\description{
Creates a boxplots of the distribution of (calibrated) median attribute
weights obtained from the COSA algorithm across the subsampling iterations.
See examples in \code{\link{Clustering}}.
}
\seealso{
\code{\link{Clustering}}
}
