% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/penalised_models.R
\name{PenalisedGraphical}
\alias{PenalisedGraphical}
\title{Graphical LASSO}
\usage{
PenalisedGraphical(
  xdata,
  pk = NULL,
  Lambda,
  Sequential_template = NULL,
  scale = TRUE,
  start = "cold",
  output_omega = FALSE,
  ...
)
}
\arguments{
\item{xdata}{matrix with observations as rows and variables as columns.}

\item{pk}{optional vector encoding the grouping structure. Only used for
multi-block stability selection where \code{pk} indicates the number of
variables in each group. If \code{pk=NULL}, single-block stability
selection is performed.}

\item{Lambda}{matrix of parameters controlling the level of sparsity.}

\item{Sequential_template}{logical matrix encoding the type of procedure to
use for data with multiple blocks in stability selection graphical
modelling. For multi-block estimation, the stability selection model is
constructed as the union of block-specific stable edges estimated while the
others are weakly penalised (\code{TRUE} only for the block currently being
calibrated and \code{FALSE} for other blocks). Other approaches with joint
calibration of the blocks are allowed (all entries are set to \code{TRUE}).}

\item{scale}{logical indicating if the correlation (\code{scale=TRUE}) or
covariance (\code{scale=FALSE}) matrix should be used as input of
\code{\link[glassoFast]{glassoFast}} if
\code{implementation=PenalisedGraphical}. Otherwise, this argument must be
used in the function provided in \code{implementation}.}

\item{start}{character string indicating if the algorithm should be
initialised at the estimated (inverse) covariance with previous penalty
parameters (\code{start="warm"}) or not (\code{start="cold"}). Using
\code{start="warm"} can speed-up the computations, but could lead to
convergence issues (in particular with small \code{Lambda_cardinal}). Only
used for \code{implementation=PenalisedGraphical} (see argument
\code{"start"} in \code{\link[glassoFast]{glassoFast}}).}

\item{output_omega}{logical indicating if the estimated precision matrices
should be stored and returned.}

\item{...}{additional parameters passed to the function provided in
\code{implementation}.}
}
\value{
An array with binary and symmetric adjacency matrices along the third
  dimension.
}
\description{
Runs the graphical LASSO algorithm for estimation of a Gaussian Graphical
Model (GGM). This function is not using stability.
}
\details{
The use of the procedure from Equation (4) or (5) is controlled by
  the argument "Sequential_template".
}
\examples{
# Data simulation
set.seed(1)
simul <- SimulateGraphical()

# Running graphical LASSO
myglasso <- PenalisedGraphical(
  xdata = simul$data,
  Lambda = matrix(c(0.1, 0.2), ncol = 1)
)

# Returning estimated precision matrix
myglasso <- PenalisedGraphical(
  xdata = simul$data,
  Lambda = matrix(c(0.1, 0.2), ncol = 1),
  output_omega = TRUE
)
}
\references{
\insertRef{GraphicalLassoTibshirani}{sharp}
}
\seealso{
\code{\link{GraphicalModel}}

Other underlying algorithm functions: 
\code{\link{CART}()},
\code{\link{ClusteringAlgo}()},
\code{\link{PenalisedOpenMx}()},
\code{\link{PenalisedRegression}()}
}
\concept{underlying algorithm functions}
