% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/graphical_model.R
\name{SerialGraphical}
\alias{SerialGraphical}
\title{Stability selection graphical model (internal)}
\usage{
SerialGraphical(
  xdata,
  pk = NULL,
  Lambda,
  lambda_other_blocks = 0.1,
  pi_list = seq(0.6, 0.9, by = 0.01),
  K = 100,
  tau = 0.5,
  seed = 1,
  n_cat = n_cat,
  implementation = PenalisedGraphical,
  start = "cold",
  scale = TRUE,
  resampling = "subsampling",
  cpss = FALSE,
  PFER_method = "MB",
  PFER_thr = Inf,
  FDP_thr = Inf,
  output_data = FALSE,
  verbose = TRUE,
  ...
)
}
\arguments{
\item{xdata}{data matrix with observations as rows and variables as columns.
For multi-block stability selection, the variables in data have to be
ordered by group.}

\item{pk}{optional vector encoding the grouping structure. Only used for
multi-block stability selection where \code{pk} indicates the number of
variables in each group. If \code{pk=NULL}, single-block stability
selection is performed.}

\item{Lambda}{matrix of parameters controlling the level of sparsity in the
underlying feature selection algorithm specified in \code{implementation}.
If \code{implementation="glassoFast"}, \code{Lambda} contains penalty
parameters.}

\item{lambda_other_blocks}{optional vector of parameters controlling the
level of sparsity in neighbour blocks for the multi-block procedure. To use
jointly a specific set of parameters for each block,
\code{lambda_other_blocks} must be set to \code{NULL} (not recommended).
Only used for multi-block stability selection, i.e. if \code{length(pk)>1}.}

\item{pi_list}{vector of thresholds in selection proportions. If
\code{n_cat=NULL} or \code{n_cat=2}, these values must be \code{>0} and
\code{<1}. If \code{n_cat=3}, these values must be \code{>0.5} and
\code{<1}.}

\item{K}{number of resampling iterations.}

\item{tau}{subsample size. Only used if \code{resampling="subsampling"} and
\code{cpss=FALSE}.}

\item{seed}{value of the seed to initialise the random number generator and
ensure reproducibility of the results (see \code{\link[base]{set.seed}}).}

\item{n_cat}{computation options for the stability score. Default is
\code{NULL} to use the score based on a z test. Other possible values are 2
or 3 to use the score based on the negative log-likelihood.}

\item{implementation}{function to use for graphical modelling. If
\code{implementation=PenalisedGraphical}, the algorithm implemented in
\code{\link[glassoFast]{glassoFast}} is used for regularised estimation of
a conditional independence graph. Alternatively, a user-defined function
can be provided.}

\item{start}{character string indicating if the algorithm should be
initialised at the estimated (inverse) covariance with previous penalty
parameters (\code{start="warm"}) or not (\code{start="cold"}). Using
\code{start="warm"} can speed-up the computations, but could lead to
convergence issues (in particular with small \code{Lambda_cardinal}). Only
used for \code{implementation=PenalisedGraphical} (see argument
\code{"start"} in \code{\link[glassoFast]{glassoFast}}).}

\item{scale}{logical indicating if the correlation (\code{scale=TRUE}) or
covariance (\code{scale=FALSE}) matrix should be used as input of
\code{\link[glassoFast]{glassoFast}} if
\code{implementation=PenalisedGraphical}. Otherwise, this argument must be
used in the function provided in \code{implementation}.}

\item{resampling}{resampling approach. Possible values are:
\code{"subsampling"} for sampling without replacement of a proportion
\code{tau} of the observations, or \code{"bootstrap"} for sampling with
replacement generating a resampled dataset with as many observations as in
the full sample. Alternatively, this argument can be a function to use for
resampling. This function must use arguments named \code{data} and
\code{tau} and return the IDs of observations to be included in the
resampled dataset.}

\item{cpss}{logical indicating if complementary pair stability selection
should be done. For this, the algorithm is applied on two non-overlapping
subsets of half of the observations. A feature is considered as selected if
it is selected for both subsamples. With this method, the data is split
\code{K/2} times (\code{K} models are fitted). Only used if
\code{PFER_method="MB"}.}

\item{PFER_method}{method used to compute the upper-bound of the expected
number of False Positives (or Per Family Error Rate, PFER). If
\code{PFER_method="MB"}, the method proposed by Meinshausen and Bühlmann
(2010) is used. If \code{PFER_method="SS"}, the method proposed by Shah and
Samworth (2013) under the assumption of unimodality is used.}

\item{PFER_thr}{threshold in PFER for constrained calibration by error
control. If \code{PFER_thr=Inf} and \code{FDP_thr=Inf}, unconstrained
calibration is used (the default).}

\item{FDP_thr}{threshold in the expected proportion of falsely selected
features (or False Discovery Proportion) for constrained calibration by
error control. If \code{PFER_thr=Inf} and \code{FDP_thr=Inf}, unconstrained
calibration is used (the default).}

\item{output_data}{logical indicating if the input datasets \code{xdata} and
\code{ydata} should be included in the output.}

\item{verbose}{logical indicating if a loading bar and messages should be
printed.}

\item{...}{additional parameters passed to the functions provided in
\code{implementation} or \code{resampling}.}
}
\value{
A list with: \item{S}{a matrix of the best stability scores for
  different (sets of) parameters controlling the level of sparsity in the
  underlying algorithm.} \item{Lambda}{a matrix of parameters controlling the
  level of sparsity in the underlying algorithm.} \item{Q}{a matrix of the
  average number of selected features by the underlying algorithm with
  different parameters controlling the level of sparsity.} \item{Q_s}{a
  matrix of the calibrated number of stably selected features with different
  parameters controlling the level of sparsity.} \item{P}{a matrix of
  calibrated thresholds in selection proportions for different parameters
  controlling the level of sparsity in the underlying algorithm.}
  \item{PFER}{a matrix of upper-bounds in PFER of calibrated stability
  selection models with different parameters controlling the level of
  sparsity.} \item{FDP}{a matrix of upper-bounds in FDP of calibrated
  stability selection models with different parameters controlling the level
  of sparsity.} \item{S_2d}{a matrix of stability scores obtained with
  different combinations of parameters. Columns correspond to different
  thresholds in selection proportions.} \item{PFER_2d}{a matrix of
  upper-bounds in FDP obtained with different combinations of parameters.
  Columns correspond to different thresholds in selection proportions. Only
  returned if \code{length(pk)=1}.} \item{FDP_2d}{a matrix of upper-bounds in
  PFER obtained with different combinations of parameters. Columns correspond
  to different thresholds in selection proportions. Only returned if
  \code{length(pk)=1}.} \item{selprop}{an array of selection proportions.
  Rows and columns correspond to nodes in the graph. Indices along the third
  dimension correspond to different parameters controlling the level of
  sparsity in the underlying algorithm.} \item{sign}{a matrix of signs of
  Pearson's correlations estimated from \code{xdata}.} \item{method}{a list
  with \code{type="graphical_model"} and values used for arguments
  \code{implementation}, \code{start}, \code{resampling}, \code{cpss} and
  \code{PFER_method}.} \item{params}{a list with values used for arguments
  \code{K}, \code{pi_list}, \code{tau}, \code{n_cat}, \code{pk}, \code{n}
  (number of observations in \code{xdata}), \code{PFER_thr}, \code{FDP_thr},
  \code{seed}, \code{lambda_other_blocks}, and \code{Sequential_template}.}
  The rows of \code{S}, \code{Lambda}, \code{Q}, \code{Q_s}, \code{P},
  \code{PFER}, \code{FDP}, \code{S_2d}, \code{PFER_2d} and \code{FDP_2d}, and
  indices along the third dimension of \code{selprop} are ordered in the same
  way and correspond to parameter values stored in \code{Lambda}. For
  multi-block inference, the columns of \code{S}, \code{Lambda}, \code{Q},
  \code{Q_s}, \code{P}, \code{PFER} and \code{FDP}, and indices along the
  third dimension of \code{S_2d} correspond to the different blocks.
}
\description{
Runs stability selection graphical models with different combinations of
parameters controlling the sparsity of the underlying selection algorithm
(e.g. penalty parameter for regularised models) and thresholds in selection
proportions. These two parameters are jointly calibrated by maximising the
stability score of the model (possibly under a constraint on the expected
number of falsely stably selected features). This function uses a serial
implementation and requires the grid of parameters controlling the underlying
algorithm as input (for internal use only).
}
\keyword{internal}
