

## TODO: move more hard-coded geom elements to arguments / heuristics
## NOTE: works best if distance matrix scaled to approximately {0,1}
# x: SPC object
# clust: a hierachical clustering object that can be converted into hclust
plotProfileDendrogram <- function(x, clust, scaling.factor=0.01, width=0.1, y.offset=0.1, dend.y.scale= max(clust$height * 2, na.rm=TRUE) , dend.color=par('fg'), dend.width=1, debug=FALSE, ...) {
  
  # sanity check: must be either agnes or diana object
  if(! inherits(clust, c('agnes', 'diana', 'hclust')))
    stop('clust must be an object generated by hclust(), cluster::diana() or cluster::agnes()')
  
  # convert to hclust, then phylo object
  d.hclust <- as.hclust(clust)
  dend <- as.phylo(d.hclust)
  
  # IDs from SPC and clustering object: may not be in the same order!
  d.ids <- d.hclust$labels
  x.ids <- profile_id(x)
  
  # sanity check: ID vectors should be the same length
  if( length(d.ids) != length(x.ids) ) {
    print(list(profileID=profile_id(x), clustID=d.ids, order=d.hclust$order))
    stop('inconsistent SoilProfileCollection and clustering object, inconsistent number of IDs', call. = FALSE)
  }
    
  # sanity check: all IDs must be accounted for
  sd.1 <- setdiff(d.ids, x.ids)
  sd.2 <- setdiff(x.ids, d.ids)
  
  if( length(sd.1) > 0 ) {
    print(list(profileID=profile_id(x), clustID=d.ids, order=d.hclust$order))
    msg <- sprintf('IDs missing from SoilProfileCollection: [%s]', paste(sd.1, collapse = ', '))
    stop(msg, call. = FALSE)
  }
    
  if( length(sd.2) > 0 ) {
    print(list(profileID=profile_id(x), clustID=d.ids, order=d.hclust$order))
    msg <- sprintf('IDs missing from cluster object: [%s]', paste(sd.1, collapse = ', '))
    stop(msg, call. = FALSE)
  }
  
  
  # profile IDs and clustering IDs may not be in the same order
  if(any(x.ids != d.ids)){
    message('profile IDs and clustering IDs are not in the same order')
  }
  
  # plotting order
  # create a link between dendrogram-tip-sorted IDS ---> profile IDs
  link.idx <- match(d.ids[d.hclust$order], x.ids)
  
  # allocate extra space
  if(debug){
    par(mar=c(5,5,5,5))
  }
  
  # setup plot and add dendrogram
  plot(dend, cex=0.8, direction='up', y.lim=c(dend.y.scale, 0), x.lim=c(0.5, length(x)+1), show.tip.label=(debug), edge.color=dend.color, edge.width=dend.width)
  
  # get the last plot geometry
  lastPP <- get("last_plot.phylo", envir = .PlotPhyloEnv)
  
  # plot the profiles, in the ordering defined by the dendrogram
  # with a couple fudge factors to make them fit
  plot(x, plot.order=link.idx, add=TRUE, width=width, scaling.factor=scaling.factor, y.offset=max(lastPP$yy) + y.offset, ...)
  
  
  if(debug) {
    # grid()
    axis(1, las=1, at=1:length(x))
    axis(2, las=1)
    # abline(h=max(lastPP$yy) + y.offset, col='red')
    
    # IDs and linking structure
    return(
      invisible(
        data.frame(
          profileID=x.ids, 
          clustID=d.ids, 
          clustID.ordered=d.ids[d.hclust$order],
          profile.plot.order=link.idx
        )
      )
    )
  
    
  }
  
  
  
}

