% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/samplingStability.R
\name{samplingStability}
\alias{samplingStability}
\title{Estimate Sampling Stability}
\usage{
samplingStability(
  mu,
  r,
  n.set = c(0.01, 0.1, 0.5, 1, 2),
  n.reps = 10,
  p.id = "pID"
)
}
\arguments{
\item{mu}{map unit polygons, must have polygon ID, must be in CRS with units of meters}

\item{r}{RasterLayer}

\item{n.set}{set of sampling density values to try}

\item{n.reps}{number of replications}

\item{p.id}{polygon ID column name}
}
\value{
data.frame with median stability values as percentage of population median, range: \verb{[0,1]}
}
\description{
Stability is defined as the width of the 5th-95th percentile range, over n.reps replications of median estimates associated with sampling events. The resulting width is scaled by the population median and returned as a fraction.
}
\author{
D.E. Beaudette
}
