#' Calculates the shattering coefficient simulations.
#'
#' @description Calculates different values of shattering coefficient,
#' varying # of samples to study the # of samples needed to ensure learning
#' and plot this values.
#'
#' @param rpart.tree rpart.tree. A Decision tree generated by rpart package.
#' @param n_experimentations int. The # of experimentations and samples to run.
#'
#' @usage shattering_simulations(rpart.tree, n_experimentations=200000)
#'
#' @return No return value, the function plot shattering simulations.
#'
#' @export shattering_simulations
shattering_simulations <- function(rpart.tree, n_experimentations=200000){
    shatterings = NULL

    for (i in seq(1, n_experimentations)){
        shatterings <- c(shatterings, compute_shattering(rpart.tree, i))
    }

    plot(shatterings, main="Measures of Shattering Coefficient by # of samples",
         ylab="Shattering coefficient", xlab="# of samples")
}
