% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Baseline.R
\name{getBaselineStats}
\alias{getBaselineStats}
\title{Gets the summary statistics of a Baseline object}
\usage{
getBaselineStats(baseline)
}
\arguments{
\item{baseline}{\code{Baseline} object that has been run through
either \link{groupBaseline} or \link{summarizeBaseline}.}
}
\value{
A \code{data.frame} with the BASELINe selection strength scores (Sigma),
          95\% confidence intervals and P-values.
}
\description{
\code{getBaselineStats} is an accessor method that returns the 
summary statistics \code{data.frame} stored in the \code{stats} slot of a 
\link{Baseline} object - provided \link{groupBaseline} has already been run.
}
\examples{
# Subset example data
db <- subset(InfluenzaDb, CPRIMER \%in\% c("IGHA","IGHM") & 
                          BARCODE \%in\% c("RL016","RL018","RL019","RL021"))

# Calculate BASELINe
# By default, calcBaseline collapses the sequences in the db by the column "CLONE",
# calculates the numbers of observed mutations and expected frequencies of mutations,
# as defined in the IMGT_V_NO_CDR3 and using the HS5FModel targeting model.
# Then, it calculates  the BASELINe posterior probability density functions (PDFs) for
# sequences in the updated db files; using the focused test statistic
db_baseline <- calcBaseline(db, 
                            sequenceColumn="SEQUENCE_IMGT",
                            germlineColumn="GERMLINE_IMGT_D_MASK", 
                            testStatistic="focused",
                            regionDefinition=IMGT_V_NO_CDR3,
                            targetingModel = HS5FModel,
                            nproc = 1)

# Grouping the PDFs by the BARCODE and CPRIMER columns in the db, corresponding 
# respectively to sample barcodes and the constant region isotype primers.
baseline_group <- groupBaseline(db_baseline, groupBy=c("BARCODE", "CPRIMER"))

# Get a data.frame of the summary statistics
getBaselineStats(baseline_group)

}
\seealso{
For calculating the BASELINe summary statistics see \link{summarizeBaseline}.
}

