% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TargetingModels.R
\name{createTargetingModel}
\alias{createTargetingModel}
\title{Creates a TargetingModel}
\usage{
createTargetingModel(
  db,
  model = c("s", "rs"),
  sequenceColumn = "sequence_alignment",
  germlineColumn = "germline_alignment_d_mask",
  vCallColumn = "v_call",
  multipleMutation = c("independent", "ignore"),
  minNumMutations = 50,
  minNumSeqMutations = 500,
  modelName = "",
  modelDescription = "",
  modelSpecies = "",
  modelCitation = "",
  modelDate = NULL
)
}
\arguments{
\item{db}{data.frame containing sequence data.}

\item{model}{type of model to create. The default model, "s", 
builds a model by counting only silent mutations. \code{model="s"}
should be used for data that includes functional sequences.
Setting \code{model="rs"} creates a model by counting both 
replacement and silent mutations and may be used on fully 
non-functional sequence data sets.}

\item{sequenceColumn}{name of the column containing IMGT-gapped sample sequences.}

\item{germlineColumn}{name of the column containing IMGT-gapped germline sequences.}

\item{vCallColumn}{name of the column containing the V-segment allele calls.}

\item{multipleMutation}{string specifying how to handle multiple mutations occuring 
within the same 5-mer. If \code{"independent"} then multiple 
mutations within the same 5-mer are counted indepedently. 
If \code{"ignore"} then 5-mers with multiple mutations are 
excluded from the otal mutation tally.}

\item{minNumMutations}{minimum number of mutations required to compute the 5-mer 
substitution rates. If the number of mutations for a 5-mer
is below this threshold, its substitution rates will be 
estimated from neighboring 5-mers. Default is 50.}

\item{minNumSeqMutations}{minimum number of mutations in sequences containing each 5-mer
to compute the mutability rates. If the number is smaller 
than this threshold, the mutability for the 5-mer will be 
inferred. Default is 500.}

\item{modelName}{name of the model.}

\item{modelDescription}{description of the model and its source data.}

\item{modelSpecies}{genus and species of the source sequencing data.}

\item{modelCitation}{publication source.}

\item{modelDate}{date the model was built. If \code{NULL} the current date
will be used.}
}
\value{
A \link{TargetingModel} object.
}
\description{
\code{createTargetingModel} creates a 5-mer \code{TargetingModel}.
}
\details{
\strong{Caution: The targeting model functions do NOT support ambiguous 
          characters in their inputs. You MUST make sure that your input and germline
          sequences do NOT contain ambiguous characters (especially if they are
          clonal consensuses returned from \code{collapseClones}).}
}
\examples{
\donttest{
# Subset example data to one isotype and sample as a demo
data(ExampleDb, package="alakazam")
db <- subset(ExampleDb, c_call == "IGHA" & sample_id == "-1h")

# Create model using only silent mutations and ignore multiple mutations
model <- createTargetingModel(db, model="s", sequenceColumn="sequence_alignment",
                              germlineColumn="germline_alignment_d_mask",
                              vCallColumn="v_call", multipleMutation="ignore")


# Access and view mutability estimates (not run)
print(model@mutability)

# View the number of S mutations used for estimating mutabilities
model@mutability@numMutS
}
}
\references{
\enumerate{
  \item  Yaari G, et al. Models of somatic hypermutation targeting and substitution based
           on synonymous mutations from high-throughput immunoglobulin sequencing data.
           Front Immunol. 2013 4(November):358.
 }
}
\seealso{
See \link{TargetingModel} for the return object. 
          See \link{plotMutability} plotting a mutability model.
          See \link{createSubstitutionMatrix}, \link{extendSubstitutionMatrix}, 
          \link{createMutabilityMatrix}, \link{extendMutabilityMatrix} and 
          \link{createTargetingMatrix} for component steps in building a model.
}
