% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/render.R
\name{render}
\alias{render}
\title{Render a 'shidashi' project}
\usage{
render(
  root_path = template_root(),
  ...,
  launch_browser = TRUE,
  as_job = TRUE,
  test_mode = getOption("shiny.testmode", FALSE)
)
}
\arguments{
\item{root_path}{the project path, default is the demo folder from
\code{template_root()}}

\item{...}{additional parameters passed to \code{\link[shiny]{runApp}},
such as \code{host}, \code{port}}

\item{launch_browser}{whether to launch browser; default is \code{TRUE}}

\item{as_job}{whether to run as 'RStudio' jobs; this options is only
available when 'RStudio' is available}

\item{test_mode}{whether to test the project; this options is helpful when
you want to debug the project without relaunching shiny applications}
}
\value{
This functions runs a 'shiny' application, and returns the job id
if 'RStudio' is available.
}
\description{
Render a 'shidashi' project
}
\examples{

template_root()

if(interactive()){
  render()
}

}
